/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.database.model.DbSystemOptions;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListDbVersionsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Integer limit;
    private String page;
    private String dbSystemShape;
    private String dbSystemId;
    private DbSystemOptions.StorageManagement storageManagement;
    private Boolean isUpgradeSupported;
    private Boolean isDatabaseSoftwareImageSupported;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getDbSystemShape() {
        return this.dbSystemShape;
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public DbSystemOptions.StorageManagement getStorageManagement() {
        return this.storageManagement;
    }

    public Boolean getIsUpgradeSupported() {
        return this.isUpgradeSupported;
    }

    public Boolean getIsDatabaseSoftwareImageSupported() {
        return this.isDatabaseSoftwareImageSupported;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).limit(this.limit).page(this.page).dbSystemShape(this.dbSystemShape).dbSystemId(this.dbSystemId).storageManagement(this.storageManagement).isUpgradeSupported(this.isUpgradeSupported).isDatabaseSoftwareImageSupported(this.isDatabaseSoftwareImageSupported);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",dbSystemShape=").append(String.valueOf(this.dbSystemShape));
        sb.append(",dbSystemId=").append(String.valueOf(this.dbSystemId));
        sb.append(",storageManagement=").append(String.valueOf((Object)this.storageManagement));
        sb.append(",isUpgradeSupported=").append(String.valueOf(this.isUpgradeSupported));
        sb.append(",isDatabaseSoftwareImageSupported=").append(String.valueOf(this.isDatabaseSoftwareImageSupported));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListDbVersionsRequest)) {
            return false;
        }
        ListDbVersionsRequest other = (ListDbVersionsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.dbSystemShape, other.dbSystemShape) && Objects.equals(this.dbSystemId, other.dbSystemId) && Objects.equals((Object)this.storageManagement, (Object)other.storageManagement) && Objects.equals(this.isUpgradeSupported, other.isUpgradeSupported) && Objects.equals(this.isDatabaseSoftwareImageSupported, other.isDatabaseSoftwareImageSupported);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.dbSystemShape == null ? 43 : this.dbSystemShape.hashCode());
        result = result * 59 + (this.dbSystemId == null ? 43 : this.dbSystemId.hashCode());
        result = result * 59 + (this.storageManagement == null ? 43 : this.storageManagement.hashCode());
        result = result * 59 + (this.isUpgradeSupported == null ? 43 : this.isUpgradeSupported.hashCode());
        result = result * 59 + (this.isDatabaseSoftwareImageSupported == null ? 43 : this.isDatabaseSoftwareImageSupported.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDbVersionsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private Integer limit = null;
        private String page = null;
        private String dbSystemShape = null;
        private String dbSystemId = null;
        private DbSystemOptions.StorageManagement storageManagement = null;
        private Boolean isUpgradeSupported = null;
        private Boolean isDatabaseSoftwareImageSupported = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder dbSystemShape(String dbSystemShape) {
            this.dbSystemShape = dbSystemShape;
            return this;
        }

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public Builder storageManagement(DbSystemOptions.StorageManagement storageManagement) {
            this.storageManagement = storageManagement;
            return this;
        }

        public Builder isUpgradeSupported(Boolean isUpgradeSupported) {
            this.isUpgradeSupported = isUpgradeSupported;
            return this;
        }

        public Builder isDatabaseSoftwareImageSupported(Boolean isDatabaseSoftwareImageSupported) {
            this.isDatabaseSoftwareImageSupported = isDatabaseSoftwareImageSupported;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDbVersionsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.dbSystemShape(o.getDbSystemShape());
            this.dbSystemId(o.getDbSystemId());
            this.storageManagement(o.getStorageManagement());
            this.isUpgradeSupported(o.getIsUpgradeSupported());
            this.isDatabaseSoftwareImageSupported(o.getIsDatabaseSoftwareImageSupported());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDbVersionsRequest build() {
            ListDbVersionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListDbVersionsRequest buildWithoutInvocationCallback() {
            ListDbVersionsRequest request = new ListDbVersionsRequest();
            request.compartmentId = this.compartmentId;
            request.limit = this.limit;
            request.page = this.page;
            request.dbSystemShape = this.dbSystemShape;
            request.dbSystemId = this.dbSystemId;
            request.storageManagement = this.storageManagement;
            request.isUpgradeSupported = this.isUpgradeSupported;
            request.isDatabaseSoftwareImageSupported = this.isDatabaseSoftwareImageSupported;
            return request;
        }
    }
}

