/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.database.model.DataCollectionOptions;
import com.oracle.bmc.database.model.DbSystemOptions;
import com.oracle.bmc.database.model.LaunchDbSystemDetails;
import com.oracle.bmc.database.model.LaunchDbSystemFromBackupDetails;
import com.oracle.bmc.database.model.LaunchDbSystemFromDatabaseDetails;
import com.oracle.bmc.database.model.LaunchDbSystemFromDbSystemDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="source", defaultImpl=LaunchDbSystemBase.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=LaunchDbSystemDetails.class, name="NONE"), @JsonSubTypes.Type(value=LaunchDbSystemFromDbSystemDetails.class, name="DB_SYSTEM"), @JsonSubTypes.Type(value=LaunchDbSystemFromDatabaseDetails.class, name="DATABASE"), @JsonSubTypes.Type(value=LaunchDbSystemFromBackupDetails.class, name="DB_BACKUP")})
@JsonFilter(value="explicitlySetFilter")
public class LaunchDbSystemBase
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="faultDomains")
    private final List<String> faultDomains;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="backupSubnetId")
    private final String backupSubnetId;
    @JsonProperty(value="nsgIds")
    private final List<String> nsgIds;
    @JsonProperty(value="backupNetworkNsgIds")
    private final List<String> backupNetworkNsgIds;
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="timeZone")
    private final String timeZone;
    @JsonProperty(value="dbSystemOptions")
    private final DbSystemOptions dbSystemOptions;
    @JsonProperty(value="storageVolumePerformanceMode")
    private final StorageVolumePerformanceMode storageVolumePerformanceMode;
    @JsonProperty(value="sparseDiskgroup")
    private final Boolean sparseDiskgroup;
    @JsonProperty(value="sshPublicKeys")
    private final List<String> sshPublicKeys;
    @JsonProperty(value="hostname")
    private final String hostname;
    @JsonProperty(value="domain")
    private final String domain;
    @JsonProperty(value="cpuCoreCount")
    private final Integer cpuCoreCount;
    @JsonProperty(value="clusterName")
    private final String clusterName;
    @JsonProperty(value="dataStoragePercentage")
    private final Integer dataStoragePercentage;
    @JsonProperty(value="initialDataStorageSizeInGB")
    private final Integer initialDataStorageSizeInGB;
    @JsonProperty(value="kmsKeyId")
    private final String kmsKeyId;
    @JsonProperty(value="kmsKeyVersionId")
    private final String kmsKeyVersionId;
    @JsonProperty(value="nodeCount")
    private final Integer nodeCount;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="privateIp")
    private final String privateIp;
    @JsonProperty(value="dataCollectionOptions")
    private final DataCollectionOptions dataCollectionOptions;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "faultDomains", "displayName", "availabilityDomain", "subnetId", "backupSubnetId", "nsgIds", "backupNetworkNsgIds", "shape", "timeZone", "dbSystemOptions", "storageVolumePerformanceMode", "sparseDiskgroup", "sshPublicKeys", "hostname", "domain", "cpuCoreCount", "clusterName", "dataStoragePercentage", "initialDataStorageSizeInGB", "kmsKeyId", "kmsKeyVersionId", "nodeCount", "freeformTags", "definedTags", "privateIp", "dataCollectionOptions"})
    protected LaunchDbSystemBase(String compartmentId, List<String> faultDomains, String displayName, String availabilityDomain, String subnetId, String backupSubnetId, List<String> nsgIds, List<String> backupNetworkNsgIds, String shape, String timeZone, DbSystemOptions dbSystemOptions, StorageVolumePerformanceMode storageVolumePerformanceMode, Boolean sparseDiskgroup, List<String> sshPublicKeys, String hostname, String domain, Integer cpuCoreCount, String clusterName, Integer dataStoragePercentage, Integer initialDataStorageSizeInGB, String kmsKeyId, String kmsKeyVersionId, Integer nodeCount, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String privateIp, DataCollectionOptions dataCollectionOptions) {
        this.compartmentId = compartmentId;
        this.faultDomains = faultDomains;
        this.displayName = displayName;
        this.availabilityDomain = availabilityDomain;
        this.subnetId = subnetId;
        this.backupSubnetId = backupSubnetId;
        this.nsgIds = nsgIds;
        this.backupNetworkNsgIds = backupNetworkNsgIds;
        this.shape = shape;
        this.timeZone = timeZone;
        this.dbSystemOptions = dbSystemOptions;
        this.storageVolumePerformanceMode = storageVolumePerformanceMode;
        this.sparseDiskgroup = sparseDiskgroup;
        this.sshPublicKeys = sshPublicKeys;
        this.hostname = hostname;
        this.domain = domain;
        this.cpuCoreCount = cpuCoreCount;
        this.clusterName = clusterName;
        this.dataStoragePercentage = dataStoragePercentage;
        this.initialDataStorageSizeInGB = initialDataStorageSizeInGB;
        this.kmsKeyId = kmsKeyId;
        this.kmsKeyVersionId = kmsKeyVersionId;
        this.nodeCount = nodeCount;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.privateIp = privateIp;
        this.dataCollectionOptions = dataCollectionOptions;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public List<String> getFaultDomains() {
        return this.faultDomains;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getBackupSubnetId() {
        return this.backupSubnetId;
    }

    public List<String> getNsgIds() {
        return this.nsgIds;
    }

    public List<String> getBackupNetworkNsgIds() {
        return this.backupNetworkNsgIds;
    }

    public String getShape() {
        return this.shape;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public DbSystemOptions getDbSystemOptions() {
        return this.dbSystemOptions;
    }

    public StorageVolumePerformanceMode getStorageVolumePerformanceMode() {
        return this.storageVolumePerformanceMode;
    }

    public Boolean getSparseDiskgroup() {
        return this.sparseDiskgroup;
    }

    public List<String> getSshPublicKeys() {
        return this.sshPublicKeys;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getDomain() {
        return this.domain;
    }

    public Integer getCpuCoreCount() {
        return this.cpuCoreCount;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public Integer getDataStoragePercentage() {
        return this.dataStoragePercentage;
    }

    public Integer getInitialDataStorageSizeInGB() {
        return this.initialDataStorageSizeInGB;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public String getKmsKeyVersionId() {
        return this.kmsKeyVersionId;
    }

    public Integer getNodeCount() {
        return this.nodeCount;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getPrivateIp() {
        return this.privateIp;
    }

    public DataCollectionOptions getDataCollectionOptions() {
        return this.dataCollectionOptions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LaunchDbSystemBase(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", faultDomains=").append(String.valueOf(this.faultDomains));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", subnetId=").append(String.valueOf(this.subnetId));
        sb.append(", backupSubnetId=").append(String.valueOf(this.backupSubnetId));
        sb.append(", nsgIds=").append(String.valueOf(this.nsgIds));
        sb.append(", backupNetworkNsgIds=").append(String.valueOf(this.backupNetworkNsgIds));
        sb.append(", shape=").append(String.valueOf(this.shape));
        sb.append(", timeZone=").append(String.valueOf(this.timeZone));
        sb.append(", dbSystemOptions=").append(String.valueOf((Object)this.dbSystemOptions));
        sb.append(", storageVolumePerformanceMode=").append(String.valueOf((Object)this.storageVolumePerformanceMode));
        sb.append(", sparseDiskgroup=").append(String.valueOf(this.sparseDiskgroup));
        sb.append(", sshPublicKeys=").append(String.valueOf(this.sshPublicKeys));
        sb.append(", hostname=").append(String.valueOf(this.hostname));
        sb.append(", domain=").append(String.valueOf(this.domain));
        sb.append(", cpuCoreCount=").append(String.valueOf(this.cpuCoreCount));
        sb.append(", clusterName=").append(String.valueOf(this.clusterName));
        sb.append(", dataStoragePercentage=").append(String.valueOf(this.dataStoragePercentage));
        sb.append(", initialDataStorageSizeInGB=").append(String.valueOf(this.initialDataStorageSizeInGB));
        sb.append(", kmsKeyId=").append(String.valueOf(this.kmsKeyId));
        sb.append(", kmsKeyVersionId=").append(String.valueOf(this.kmsKeyVersionId));
        sb.append(", nodeCount=").append(String.valueOf(this.nodeCount));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", privateIp=").append(String.valueOf(this.privateIp));
        sb.append(", dataCollectionOptions=").append(String.valueOf((Object)this.dataCollectionOptions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LaunchDbSystemBase)) {
            return false;
        }
        LaunchDbSystemBase other = (LaunchDbSystemBase)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.faultDomains, other.faultDomains) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.subnetId, other.subnetId) && Objects.equals(this.backupSubnetId, other.backupSubnetId) && Objects.equals(this.nsgIds, other.nsgIds) && Objects.equals(this.backupNetworkNsgIds, other.backupNetworkNsgIds) && Objects.equals(this.shape, other.shape) && Objects.equals(this.timeZone, other.timeZone) && Objects.equals((Object)this.dbSystemOptions, (Object)other.dbSystemOptions) && Objects.equals((Object)this.storageVolumePerformanceMode, (Object)other.storageVolumePerformanceMode) && Objects.equals(this.sparseDiskgroup, other.sparseDiskgroup) && Objects.equals(this.sshPublicKeys, other.sshPublicKeys) && Objects.equals(this.hostname, other.hostname) && Objects.equals(this.domain, other.domain) && Objects.equals(this.cpuCoreCount, other.cpuCoreCount) && Objects.equals(this.clusterName, other.clusterName) && Objects.equals(this.dataStoragePercentage, other.dataStoragePercentage) && Objects.equals(this.initialDataStorageSizeInGB, other.initialDataStorageSizeInGB) && Objects.equals(this.kmsKeyId, other.kmsKeyId) && Objects.equals(this.kmsKeyVersionId, other.kmsKeyVersionId) && Objects.equals(this.nodeCount, other.nodeCount) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.privateIp, other.privateIp) && Objects.equals((Object)this.dataCollectionOptions, (Object)other.dataCollectionOptions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.faultDomains == null ? 43 : this.faultDomains.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.backupSubnetId == null ? 43 : this.backupSubnetId.hashCode());
        result = result * 59 + (this.nsgIds == null ? 43 : this.nsgIds.hashCode());
        result = result * 59 + (this.backupNetworkNsgIds == null ? 43 : this.backupNetworkNsgIds.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.timeZone == null ? 43 : this.timeZone.hashCode());
        result = result * 59 + (this.dbSystemOptions == null ? 43 : this.dbSystemOptions.hashCode());
        result = result * 59 + (this.storageVolumePerformanceMode == null ? 43 : this.storageVolumePerformanceMode.hashCode());
        result = result * 59 + (this.sparseDiskgroup == null ? 43 : this.sparseDiskgroup.hashCode());
        result = result * 59 + (this.sshPublicKeys == null ? 43 : this.sshPublicKeys.hashCode());
        result = result * 59 + (this.hostname == null ? 43 : this.hostname.hashCode());
        result = result * 59 + (this.domain == null ? 43 : this.domain.hashCode());
        result = result * 59 + (this.cpuCoreCount == null ? 43 : this.cpuCoreCount.hashCode());
        result = result * 59 + (this.clusterName == null ? 43 : this.clusterName.hashCode());
        result = result * 59 + (this.dataStoragePercentage == null ? 43 : this.dataStoragePercentage.hashCode());
        result = result * 59 + (this.initialDataStorageSizeInGB == null ? 43 : this.initialDataStorageSizeInGB.hashCode());
        result = result * 59 + (this.kmsKeyId == null ? 43 : this.kmsKeyId.hashCode());
        result = result * 59 + (this.kmsKeyVersionId == null ? 43 : this.kmsKeyVersionId.hashCode());
        result = result * 59 + (this.nodeCount == null ? 43 : this.nodeCount.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.privateIp == null ? 43 : this.privateIp.hashCode());
        result = result * 59 + (this.dataCollectionOptions == null ? 43 : this.dataCollectionOptions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Source implements BmcEnum
    {
        None("NONE"),
        DbBackup("DB_BACKUP"),
        Database("DATABASE"),
        DbSystem("DB_SYSTEM");

        private final String value;
        private static Map<String, Source> map;

        private Source(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Source create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Source: " + key);
        }

        static {
            map = new HashMap<String, Source>();
            for (Source v : Source.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum StorageVolumePerformanceMode implements BmcEnum
    {
        Balanced("BALANCED"),
        HighPerformance("HIGH_PERFORMANCE");

        private final String value;
        private static Map<String, StorageVolumePerformanceMode> map;

        private StorageVolumePerformanceMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static StorageVolumePerformanceMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid StorageVolumePerformanceMode: " + key);
        }

        static {
            map = new HashMap<String, StorageVolumePerformanceMode>();
            for (StorageVolumePerformanceMode v : StorageVolumePerformanceMode.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

