/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.DatabaseConnectionStringProfile;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AutonomousDatabaseConnectionStrings
extends ExplicitlySetBmcModel {
    @JsonProperty(value="high")
    private final String high;
    @JsonProperty(value="medium")
    private final String medium;
    @JsonProperty(value="low")
    private final String low;
    @JsonProperty(value="dedicated")
    private final String dedicated;
    @JsonProperty(value="allConnectionStrings")
    private final Map<String, String> allConnectionStrings;
    @JsonProperty(value="profiles")
    private final List<DatabaseConnectionStringProfile> profiles;

    @Deprecated
    @ConstructorProperties(value={"high", "medium", "low", "dedicated", "allConnectionStrings", "profiles"})
    public AutonomousDatabaseConnectionStrings(String high, String medium, String low, String dedicated, Map<String, String> allConnectionStrings, List<DatabaseConnectionStringProfile> profiles) {
        this.high = high;
        this.medium = medium;
        this.low = low;
        this.dedicated = dedicated;
        this.allConnectionStrings = allConnectionStrings;
        this.profiles = profiles;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getHigh() {
        return this.high;
    }

    public String getMedium() {
        return this.medium;
    }

    public String getLow() {
        return this.low;
    }

    public String getDedicated() {
        return this.dedicated;
    }

    public Map<String, String> getAllConnectionStrings() {
        return this.allConnectionStrings;
    }

    public List<DatabaseConnectionStringProfile> getProfiles() {
        return this.profiles;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AutonomousDatabaseConnectionStrings(");
        sb.append("super=").append(super.toString());
        sb.append("high=").append(String.valueOf(this.high));
        sb.append(", medium=").append(String.valueOf(this.medium));
        sb.append(", low=").append(String.valueOf(this.low));
        sb.append(", dedicated=").append(String.valueOf(this.dedicated));
        sb.append(", allConnectionStrings=").append(String.valueOf(this.allConnectionStrings));
        sb.append(", profiles=").append(String.valueOf(this.profiles));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AutonomousDatabaseConnectionStrings)) {
            return false;
        }
        AutonomousDatabaseConnectionStrings other = (AutonomousDatabaseConnectionStrings)((Object)o);
        return Objects.equals(this.high, other.high) && Objects.equals(this.medium, other.medium) && Objects.equals(this.low, other.low) && Objects.equals(this.dedicated, other.dedicated) && Objects.equals(this.allConnectionStrings, other.allConnectionStrings) && Objects.equals(this.profiles, other.profiles) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.high == null ? 43 : this.high.hashCode());
        result = result * 59 + (this.medium == null ? 43 : this.medium.hashCode());
        result = result * 59 + (this.low == null ? 43 : this.low.hashCode());
        result = result * 59 + (this.dedicated == null ? 43 : this.dedicated.hashCode());
        result = result * 59 + (this.allConnectionStrings == null ? 43 : this.allConnectionStrings.hashCode());
        result = result * 59 + (this.profiles == null ? 43 : this.profiles.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="high")
        private String high;
        @JsonProperty(value="medium")
        private String medium;
        @JsonProperty(value="low")
        private String low;
        @JsonProperty(value="dedicated")
        private String dedicated;
        @JsonProperty(value="allConnectionStrings")
        private Map<String, String> allConnectionStrings;
        @JsonProperty(value="profiles")
        private List<DatabaseConnectionStringProfile> profiles;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder high(String high) {
            this.high = high;
            this.__explicitlySet__.add("high");
            return this;
        }

        public Builder medium(String medium) {
            this.medium = medium;
            this.__explicitlySet__.add("medium");
            return this;
        }

        public Builder low(String low) {
            this.low = low;
            this.__explicitlySet__.add("low");
            return this;
        }

        public Builder dedicated(String dedicated) {
            this.dedicated = dedicated;
            this.__explicitlySet__.add("dedicated");
            return this;
        }

        public Builder allConnectionStrings(Map<String, String> allConnectionStrings) {
            this.allConnectionStrings = allConnectionStrings;
            this.__explicitlySet__.add("allConnectionStrings");
            return this;
        }

        public Builder profiles(List<DatabaseConnectionStringProfile> profiles) {
            this.profiles = profiles;
            this.__explicitlySet__.add("profiles");
            return this;
        }

        public AutonomousDatabaseConnectionStrings build() {
            AutonomousDatabaseConnectionStrings model = new AutonomousDatabaseConnectionStrings(this.high, this.medium, this.low, this.dedicated, this.allConnectionStrings, this.profiles);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AutonomousDatabaseConnectionStrings model) {
            if (model.wasPropertyExplicitlySet("high")) {
                this.high(model.getHigh());
            }
            if (model.wasPropertyExplicitlySet("medium")) {
                this.medium(model.getMedium());
            }
            if (model.wasPropertyExplicitlySet("low")) {
                this.low(model.getLow());
            }
            if (model.wasPropertyExplicitlySet("dedicated")) {
                this.dedicated(model.getDedicated());
            }
            if (model.wasPropertyExplicitlySet("allConnectionStrings")) {
                this.allConnectionStrings(model.getAllConnectionStrings());
            }
            if (model.wasPropertyExplicitlySet("profiles")) {
                this.profiles(model.getProfiles());
            }
            return this;
        }
    }
}

