/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.embedding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.html.editor.Utils;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.embedding.JsEPPluginQuery;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.common.api.WebUtils;

public class JsEmbeddingProvider
extends EmbeddingProvider {
    private static final Logger LOGGER = Logger.getLogger(JsEmbeddingProvider.class.getSimpleName());
    private static final String JS_MIMETYPE = "text/javascript";
    private static final String BABEL_MIMETYPE = "text/babel";
    private static final String SCRIPT_TYPE_MODULE = "module";
    private static final String NETBEANS_IMPORT_FILE = "__netbeans_import__";
    private boolean cancelled = true;
    private final Language JS_LANGUAGE = Language.find((String)"text/javascript");
    private final JsEPPluginQuery PLUGINS = JsEPPluginQuery.getDefault();
    private static final Pattern GENERIC_MARK_PATTERN = Pattern.compile("@@@");
    private static final String GENERATED_JS_IDENTIFIER = "__UNKNOWN__";
    private static final Collection<String> TEMPLATING_LANGUAGES_USING_TRANSITIONAL_EMBEDDING_CREATION = new HashSet<String>(Arrays.asList("text/x-jsp", "text/x-tag", "text/xhtml", "text/x-php5"));

    public List<Embedding> getEmbeddings(final Snapshot snapshot) {
        String rootMimeType = snapshot.getMimePath().getMimeType(0);
        if (snapshot.getMimePath().size() > 1 && !TEMPLATING_LANGUAGES_USING_TRANSITIONAL_EMBEDDING_CREATION.contains(rootMimeType)) {
            return Collections.emptyList();
        }
        this.cancelled = false;
        final ArrayList embeddings = new ArrayList();
        final TokenSequence tokenSequence = snapshot.getTokenHierarchy().tokenSequence(HTMLTokenId.language());
        final JsAnalyzerState state = new JsAnalyzerState();
        try {
            ParserManager.parse(Collections.singleton(snapshot.getSource()), (UserTask)new UserTask(this){
                final /* synthetic */ JsEmbeddingProvider this$0;
                {
                    this.this$0 = this$0;
                }

                public void run(ResultIterator resultIterator) throws Exception {
                    HtmlParserResult result;
                    ResultIterator htmlRI = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/html");
                    if (htmlRI != null && (result = (HtmlParserResult)htmlRI.getParserResult()) != null) {
                        this.this$0.process(result, snapshot, (TokenSequence<HTMLTokenId>)tokenSequence, state, embeddings);
                    }
                }
            });
        }
        catch (ParseException pe) {
            LOGGER.log(Level.WARNING, null, pe);
        }
        if (embeddings.isEmpty()) {
            LOGGER.log(Level.FINE, "No javascript embedding created for source {0}", snapshot.getSource().toString());
            return Collections.emptyList();
        }
        Embedding embedding = Embedding.create(embeddings);
        LOGGER.log(Level.FINE, "Javascript embedding for source {0}:\n{1}", new Object[]{snapshot.getSource().toString(), embedding.getSnapshot().getText().toString()});
        return Collections.singletonList(embedding);
    }

    public int getPriority() {
        return 50;
    }

    public void cancel() {
        this.cancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(HtmlParserResult parserResult, Snapshot snapshot, TokenSequence<HTMLTokenId> ts, JsAnalyzerState state, List<Embedding> embeddings) {
        assert (parserResult != null);
        JsEPPluginQuery.Session session = this.PLUGINS.createSession();
        session.startProcessing(parserResult, snapshot, ts, embeddings);
        try {
            ts.moveStart();
            block11: while (ts.moveNext()) {
                if (this.cancelled) {
                    embeddings.clear();
                    return;
                }
                if (session.processToken()) continue;
                Token token = ts.token();
                switch ((HTMLTokenId)token.id()) {
                    case SCRIPT: {
                        this.handleScript(snapshot, ts, state, embeddings);
                        continue block11;
                    }
                    case TAG_OPEN: {
                        this.handleOpenTag(snapshot, ts, embeddings);
                        continue block11;
                    }
                    case TEXT: {
                        if (!state.in_javascript) continue block11;
                        embeddings.addAll(this.createEmbedding(snapshot, ts.offset(), token.length()));
                        continue block11;
                    }
                    case VALUE_JAVASCRIPT: 
                    case VALUE: {
                        this.handleValue(snapshot, ts, embeddings);
                        continue block11;
                    }
                    case TAG_CLOSE: {
                        if (!LexerUtils.equals((CharSequence)"script", (CharSequence)token.text(), (boolean)true, (boolean)true)) continue block11;
                        embeddings.addAll(JsEmbeddingProvider.createEmbedding(snapshot, "\n"));
                        continue block11;
                    }
                }
                state.in_javascript = false;
            }
        }
        finally {
            session.endProcessing();
        }
    }

    private void handleValue(Snapshot snapshot, TokenSequence<HTMLTokenId> ts, List<Embedding> embeddings) {
        if (ts.embedded(this.JS_LANGUAGE) != null) {
            embeddings.addAll(JsEmbeddingProvider.createEmbedding(snapshot, "(function(){\n"));
            int diff = Utils.isAttributeValueQuoted(ts.token().text()) ? 1 : 0;
            embeddings.addAll(this.createEmbedding(snapshot, ts.offset() + diff, ts.token().length() - diff * 2));
            embeddings.addAll(JsEmbeddingProvider.createEmbedding(snapshot, ";\n});\n"));
        }
    }

    private void handleScript(Snapshot snapshot, TokenSequence<HTMLTokenId> ts, JsAnalyzerState state, List<Embedding> embeddings) {
        String scriptType = (String)ts.token().getProperty((Object)"type");
        if (this.isValidScriptTypeAttributeValue(scriptType)) {
            state.in_javascript = true;
            int sourceStart = ts.offset();
            String text = ts.token().text().toString();
            List<EmbeddingPosition> jsEmbeddings = this.extractJsEmbeddings(text, sourceStart);
            for (EmbeddingPosition embedding : jsEmbeddings) {
                embeddings.addAll(this.createEmbedding(snapshot, embedding.getOffset(), embedding.getLength()));
            }
        }
    }

    private boolean isValidScriptTypeAttributeValue(String scriptType) {
        return scriptType == null || JS_MIMETYPE.equals(scriptType) || BABEL_MIMETYPE.equals(scriptType) || SCRIPT_TYPE_MODULE.equals(scriptType);
    }

    private void handleOpenTag(Snapshot snapshot, TokenSequence<HTMLTokenId> ts, List<Embedding> embeddings) {
        if (LexerUtils.equals((CharSequence)"script", (CharSequence)ts.token().text(), (boolean)false, (boolean)false)) {
            Token t;
            HTMLTokenId id;
            TokenSequence ets = ts.subSequence(ts.offset());
            ets.moveStart();
            boolean foundSrc = false;
            boolean foundType = false;
            String type = null;
            String src = null;
            while (ets.moveNext() && (id = (HTMLTokenId)(t = ets.token()).id()) != HTMLTokenId.TAG_CLOSE_SYMBOL) {
                String val;
                if (foundSrc || foundType) {
                    if (id == HTMLTokenId.ARGUMENT) break;
                    if (id != HTMLTokenId.VALUE) continue;
                    if (foundSrc) {
                        src = t.text().toString();
                    } else {
                        assert (foundType);
                        type = t.text().toString();
                    }
                    foundSrc = false;
                    foundType = false;
                    continue;
                }
                if (id != HTMLTokenId.ARGUMENT) continue;
                switch (val = t.text().toString()) {
                    case "src": {
                        foundSrc = true;
                        break;
                    }
                    case "type": {
                        foundType = true;
                    }
                }
            }
            if (src != null && (type == null || type.toLowerCase().indexOf("javascript") != -1)) {
                if (src.length() > 2 && src.startsWith("\"") && src.endsWith("\"")) {
                    src = src.substring(1, src.length() - 1);
                }
                if (src.length() > 2 && src.startsWith("'") && src.endsWith("'")) {
                    src = src.substring(1, src.length() - 1);
                }
                String insertText = "__netbeans_import__('" + src + "');\n";
                embeddings.addAll(JsEmbeddingProvider.createEmbedding(snapshot, insertText));
            }
        }
    }

    private List<EmbeddingPosition> extractJsEmbeddings(String text, int sourceStart) {
        int lineEnd;
        char c;
        int start;
        LinkedList<EmbeddingPosition> embeddings = new LinkedList<EmbeddingPosition>();
        for (start = 0; start < text.length() && Character.isWhitespace(c = text.charAt(start)); ++start) {
        }
        if (start < text.length() && text.startsWith("<!--", start) && this.isHtmlCommentStartToSkip(text, start, lineEnd = text.indexOf(10, start))) {
            String helpText;
            int index;
            int end;
            if (start > 0) {
                embeddings.add(new EmbeddingPosition(sourceStart, start));
            }
            sourceStart += ++lineEnd;
            text = text.substring(lineEnd);
            for (end = text.length() - 1; end > -1 && Character.isWhitespace(text.charAt(end)); --end) {
            }
            if (end > 4 && (index = text.indexOf("-->", end - 4)) != -1 && (helpText = text.substring(0, index)).lastIndexOf("<!--") <= helpText.lastIndexOf("-->")) {
                text = helpText;
            }
        }
        Scanner scanner = new Scanner(text).useDelimiter("(<!--).*(-->)");
        while (scanner.hasNext()) {
            scanner.next();
            MatchResult match = scanner.match();
            embeddings.add(new EmbeddingPosition(sourceStart + match.start(), match.group().length()));
        }
        return embeddings;
    }

    private boolean isHtmlCommentStartToSkip(String text, int start, int lineEnd) {
        if (lineEnd != -1) {
            if (text.startsWith("<!--//-->", start)) {
                return true;
            }
            return text.indexOf("-->", start) == -1 || lineEnd < text.indexOf("-->", start);
        }
        return false;
    }

    private static Collection<Embedding> createEmbedding(Snapshot snapshot, CharSequence text) {
        String replaced = GENERIC_MARK_PATTERN.matcher(text).replaceAll(GENERATED_JS_IDENTIFIER);
        return Collections.singleton(snapshot.create((CharSequence)replaced, JS_MIMETYPE));
    }

    private Collection<Embedding> createEmbedding(Snapshot snapshot, int offset, int len) {
        ArrayList<Embedding> es = new ArrayList<Embedding>();
        CharSequence text = snapshot.getText().subSequence(offset, offset + len);
        Matcher matcher = GENERIC_MARK_PATTERN.matcher(text);
        int tmpOffset = 0;
        while (matcher.find()) {
            int end;
            int start = matcher.start();
            if (start == (end = matcher.end())) continue;
            es.add(snapshot.create(offset + tmpOffset, start - tmpOffset, JS_MIMETYPE));
            tmpOffset = end;
            if (matcher.hitEnd()) continue;
            es.add(snapshot.create((CharSequence)GENERATED_JS_IDENTIFIER, JS_MIMETYPE));
        }
        es.add(snapshot.create(offset + tmpOffset, text.length() - tmpOffset, JS_MIMETYPE));
        return es;
    }

    private static final class JsAnalyzerState {
        boolean in_javascript = false;

        private JsAnalyzerState() {
        }
    }

    protected static final class EmbeddingPosition {
        private final int offset;
        private final int length;

        public EmbeddingPosition(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

