/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AlarmHistoryEntry
extends ExplicitlySetBmcModel {
    @JsonProperty(value="summary")
    private final String summary;
    @JsonProperty(value="timestamp")
    private final Date timestamp;
    @JsonProperty(value="timestampTriggered")
    private final Date timestampTriggered;

    @Deprecated
    @ConstructorProperties(value={"summary", "timestamp", "timestampTriggered"})
    public AlarmHistoryEntry(String summary, Date timestamp, Date timestampTriggered) {
        this.summary = summary;
        this.timestamp = timestamp;
        this.timestampTriggered = timestampTriggered;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSummary() {
        return this.summary;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Date getTimestampTriggered() {
        return this.timestampTriggered;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AlarmHistoryEntry(");
        sb.append("super=").append(super.toString());
        sb.append("summary=").append(String.valueOf(this.summary));
        sb.append(", timestamp=").append(String.valueOf(this.timestamp));
        sb.append(", timestampTriggered=").append(String.valueOf(this.timestampTriggered));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlarmHistoryEntry)) {
            return false;
        }
        AlarmHistoryEntry other = (AlarmHistoryEntry)((Object)o);
        return Objects.equals(this.summary, other.summary) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.timestampTriggered, other.timestampTriggered) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.summary == null ? 43 : this.summary.hashCode());
        result = result * 59 + (this.timestamp == null ? 43 : this.timestamp.hashCode());
        result = result * 59 + (this.timestampTriggered == null ? 43 : this.timestampTriggered.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="summary")
        private String summary;
        @JsonProperty(value="timestamp")
        private Date timestamp;
        @JsonProperty(value="timestampTriggered")
        private Date timestampTriggered;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder summary(String summary) {
            this.summary = summary;
            this.__explicitlySet__.add("summary");
            return this;
        }

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            this.__explicitlySet__.add("timestamp");
            return this;
        }

        public Builder timestampTriggered(Date timestampTriggered) {
            this.timestampTriggered = timestampTriggered;
            this.__explicitlySet__.add("timestampTriggered");
            return this;
        }

        public AlarmHistoryEntry build() {
            AlarmHistoryEntry model = new AlarmHistoryEntry(this.summary, this.timestamp, this.timestampTriggered);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AlarmHistoryEntry model) {
            if (model.wasPropertyExplicitlySet("summary")) {
                this.summary(model.getSummary());
            }
            if (model.wasPropertyExplicitlySet("timestamp")) {
                this.timestamp(model.getTimestamp());
            }
            if (model.wasPropertyExplicitlySet("timestampTriggered")) {
                this.timestampTriggered(model.getTimestampTriggered());
            }
            return this;
        }
    }
}

