/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JToolTip;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsEngineListener;
import org.netbeans.modules.debugger.jpda.ui.models.Bundle;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.WeakSet;

public class BreakpointsHitCountModel
implements TableModelFilter,
BreakpointImpl.HitCountListener {
    public static final String HC_COLUMN_ID = "HitCountBreakCount";
    private final List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();
    private final ContextProvider lookupProvider;
    private BreakpointsEngineListener breakpointsEngineListener;
    private final Set<BreakpointImpl> bpImplListeningOn = new WeakSet();

    public BreakpointsHitCountModel(ContextProvider lookupProvider) {
        this.lookupProvider = lookupProvider;
    }

    public Object getValueAt(TableModel original, Object node, String columnID) throws UnknownTypeException {
        if (HC_COLUMN_ID.equals(columnID)) {
            if (node instanceof JPDABreakpoint) {
                JPDABreakpoint b = (JPDABreakpoint)node;
                BreakpointImpl bpImpl = this.getBPImpl(b);
                if (bpImpl == null) {
                    return Bundle.MSG_HitCountUnknown();
                }
                int hc = bpImpl.getCurrentHitCount();
                int bc = bpImpl.getCurrentBreakCounts();
                boolean isHCFilterSet = b.getHitCountFilter() != 0;
                int hctb = bpImpl.getHitCountsTillBreak();
                if (isHCFilterSet && hctb >= 0) {
                    return Bundle.MSG_HitCountWithBreakCountToBreak(BreakpointsHitCountModel.hc2String(hc), BreakpointsHitCountModel.hc2String(bc), BreakpointsHitCountModel.hc2String(hctb));
                }
                if (hc == bc) {
                    return BreakpointsHitCountModel.hc2String(hc);
                }
                return Bundle.MSG_HitCountWithBreakCount(BreakpointsHitCountModel.hc2String(hc), BreakpointsHitCountModel.hc2String(bc));
            }
            if (node instanceof JToolTip) {
                if ((node = ((JToolTip)node).getClientProperty("getShortDescription")) instanceof JPDABreakpoint) {
                    JPDABreakpoint b = (JPDABreakpoint)node;
                    BreakpointImpl bpImpl = this.getBPImpl(b);
                    if (bpImpl == null) {
                        return Bundle.TT_HitCountUnknown();
                    }
                    int hc = bpImpl.getCurrentHitCount();
                    int bc = bpImpl.getCurrentBreakCounts();
                    int hctb = bpImpl.getHitCountsTillBreak();
                    String tt = hctb >= 0 ? Bundle.TT_HitCountToBreak(BreakpointsHitCountModel.hc2String(hc), BreakpointsHitCountModel.hc2String(bc), BreakpointsHitCountModel.hc2String(hctb)) : Bundle.TT_HitCount(BreakpointsHitCountModel.hc2String(hc), BreakpointsHitCountModel.hc2String(bc));
                    return tt;
                }
                throw new UnknownTypeException(node);
            }
            throw new UnknownTypeException(node);
        }
        return original.getValueAt(node, columnID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BreakpointImpl getBPImpl(JPDABreakpoint b) {
        BreakpointsEngineListener bel = this.getBreakpointsEngineListener();
        if (bel == null) {
            return null;
        }
        BreakpointImpl bpImpl = bel.getBreakpointImpl((Breakpoint)b);
        if (bpImpl != null) {
            Set<BreakpointImpl> set = this.bpImplListeningOn;
            synchronized (set) {
                if (!this.bpImplListeningOn.contains(bpImpl)) {
                    bpImpl.addHitCountListener((BreakpointImpl.HitCountListener)this);
                    this.bpImplListeningOn.add(bpImpl);
                }
            }
        }
        return bpImpl;
    }

    private static final String hc2String(int hc) {
        return hc >= 0 ? Integer.toString(hc) : "?";
    }

    public void setValueAt(TableModel original, Object node, String columnID, Object value) throws UnknownTypeException {
        original.setValueAt(node, columnID, value);
    }

    public boolean isReadOnly(TableModel original, Object node, String columnID) throws UnknownTypeException {
        if (HC_COLUMN_ID.equals(columnID)) {
            return true;
        }
        return original.isReadOnly(node, columnID);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    private void fireTableModelEvent(Object node) {
        ModelEvent.TableValueChanged me = new ModelEvent.TableValueChanged((Object)this, node, HC_COLUMN_ID);
        for (ModelListener l : this.listeners) {
            l.modelChanged((ModelEvent)me);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BreakpointsEngineListener getBreakpointsEngineListener() {
        BreakpointsHitCountModel breakpointsHitCountModel = this;
        synchronized (breakpointsHitCountModel) {
            if (this.breakpointsEngineListener != null) {
                return this.breakpointsEngineListener;
            }
        }
        List lamls = this.lookupProvider.lookup(null, LazyActionsManagerListener.class);
        for (LazyActionsManagerListener laml : lamls) {
            if (!(laml instanceof BreakpointsEngineListener)) continue;
            BreakpointsEngineListener bel = (BreakpointsEngineListener)laml;
            BreakpointsHitCountModel breakpointsHitCountModel2 = this;
            synchronized (breakpointsHitCountModel2) {
                if (this.breakpointsEngineListener == null) {
                    this.breakpointsEngineListener = bel;
                }
            }
            return bel;
        }
        return null;
    }

    public void hitCountChanged(JPDABreakpoint bp) {
        this.fireTableModelEvent(bp);
    }

    public static final class HCColumn
    extends ColumnModel {
        private final Properties properties = Properties.getDefault().getProperties("debugger").getProperties("views").getProperties("HitCountBreakCount");

        public String getID() {
            return BreakpointsHitCountModel.HC_COLUMN_ID;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(BreakpointsHitCountModel.class, (String)"TTL_HC_Column");
        }

        public String getShortDescription() {
            return NbBundle.getMessage(BreakpointsHitCountModel.class, (String)"TTL_HC_Column_Tooltip");
        }

        public int getColumnWidth() {
            return this.properties.getInt("columnWidth", 80);
        }

        public void setColumnWidth(int newColumnWidth) {
            this.properties.setInt("columnWidth", newColumnWidth);
        }

        public int getCurrentOrderNumber() {
            return this.properties.getInt("currentOrderNumber", super.getCurrentOrderNumber());
        }

        public void setCurrentOrderNumber(int newOrderNumber) {
            this.properties.setInt("currentOrderNumber", newOrderNumber);
        }

        public boolean isSortable() {
            return true;
        }

        public boolean isSorted() {
            return this.properties.getBoolean("sorted", super.isSorted());
        }

        public boolean isSortedDescending() {
            return this.properties.getBoolean("sortedDescending", super.isSortedDescending());
        }

        public void setSorted(boolean sorted) {
            this.properties.setBoolean("sorted", sorted);
        }

        public void setSortedDescending(boolean sortedDescending) {
            this.properties.setBoolean("sortedDescending", sortedDescending);
        }

        public boolean isVisible() {
            return this.properties.getBoolean("visible", false);
        }

        public void setVisible(boolean visible) {
            this.properties.setBoolean("visible", visible);
        }

        public Class getType() {
            return String.class;
        }
    }
}

