/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.search;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import org.netbeans.modules.editor.search.EditorFindSupport;
import org.openide.util.NbPreferences;

public final class SearchPropertiesSupport {
    private static final String PREFS_NODE = "SearchProperties";
    private static SearchPropertiesSupport instance = null;
    private static final Preferences prefs = NbPreferences.forModule(SearchPropertiesSupport.class).node("SearchProperties");
    private static final String SEARCH_ID = "searchprops";
    private static SearchProperties searchProps;
    private static final String REPLACE_ID = "replaceprops";
    private static SearchProperties replaceProps;
    private static final List<String> EDITOR_FIND_SUPPORT_CONSTANTS;

    private SearchPropertiesSupport() {
    }

    private static synchronized SearchPropertiesSupport getInstance() {
        if (instance == null) {
            instance = new SearchPropertiesSupport();
        }
        return instance;
    }

    private Preferences getPrefs() {
        return prefs;
    }

    public static synchronized SearchProperties getSearchProperties() {
        if (searchProps == null) {
            searchProps = SearchPropertiesSupport.createDefaultSearchProperties();
        }
        return searchProps;
    }

    public static synchronized SearchProperties getReplaceProperties() {
        if (replaceProps == null) {
            replaceProps = SearchPropertiesSupport.createDefaultReplaceProperties();
        }
        return replaceProps;
    }

    private static SearchProperties createDefaultSearchProperties() {
        Map<String, Object> props = EditorFindSupport.getInstance().createDefaultFindProperties();
        for (String constant : EDITOR_FIND_SUPPORT_CONSTANTS) {
            props.put(constant, Boolean.parseBoolean(SearchPropertiesSupport.getInstance().getPrefs().get(SEARCH_ID + constant, props.get(constant).toString())));
        }
        return new SearchProperties(props, SEARCH_ID);
    }

    private static SearchProperties createDefaultReplaceProperties() {
        Map<String, Object> props = EditorFindSupport.getInstance().createDefaultFindProperties();
        props.put("find-match-case", Boolean.TRUE);
        for (String constant : EDITOR_FIND_SUPPORT_CONSTANTS) {
            props.put(constant, Boolean.parseBoolean(SearchPropertiesSupport.getInstance().getPrefs().get(REPLACE_ID + constant, props.get(constant).toString())));
        }
        return new SearchProperties(props, REPLACE_ID);
    }

    static {
        EDITOR_FIND_SUPPORT_CONSTANTS = Arrays.asList("find-match-case", "find-whole-words", "find-reg-exp", "find-wrap-search", "find-preserve-case");
    }

    public static final class SearchProperties {
        private final Map<String, Object> props;
        private final String id;

        private SearchProperties(Map<String, Object> props, String identification) {
            this.props = props;
            this.id = identification;
        }

        public synchronized void saveToPrefs() {
            for (Map.Entry<String, Object> entry : this.props.entrySet()) {
                String editorFindSupportProperty = entry.getKey();
                Object value = entry.getValue();
                if (value != null) {
                    SearchPropertiesSupport.getInstance().getPrefs().put(this.id + editorFindSupportProperty, value.toString());
                    continue;
                }
                SearchPropertiesSupport.getInstance().getPrefs().remove(this.id + editorFindSupportProperty);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setProperty(String editorFindSupportProperty, Object value) {
            if (editorFindSupportProperty.equals("find-highlight-search")) {
                EditorFindSupport.getInstance().putFindProperty(editorFindSupportProperty, value);
            }
            SearchProperties searchProperties = this;
            synchronized (searchProperties) {
                this.props.put(editorFindSupportProperty, value);
            }
        }

        public synchronized Object getProperty(String editorFindSupportProperty) {
            this.props.put("find-highlight-search", EditorFindSupport.getInstance().getFindProperty("find-highlight-search"));
            return this.props.get(editorFindSupportProperty);
        }

        public synchronized Map<String, Object> getProperties() {
            this.props.put("find-highlight-search", EditorFindSupport.getInstance().getFindProperty("find-highlight-search"));
            return this.props;
        }
    }
}

