/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.build2;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import org.netbeans.modules.docker.ui.UiUtils;
import org.netbeans.modules.docker.ui.build2.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public final class BuildOptionsVisual
extends JPanel {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private String buildContext;
    private JButton addVariableButton;
    private JTable buildargsTable;
    private JButton deleteVariableButton;
    private JButton dockerfileButton;
    private JLabel dockerfileLabel;
    private JTextField dockerfileTextField;
    private JLabel jLabel1;
    private JScrollPane jScrollPane2;
    private JCheckBox noCacheCheckBox;
    private JCheckBox pullCheckBox;

    public BuildOptionsVisual() {
        this.initComponents();
        this.dockerfileTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                BuildOptionsVisual.this.changeSupport.fireChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                BuildOptionsVisual.this.changeSupport.fireChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                BuildOptionsVisual.this.changeSupport.fireChange();
            }
        });
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public void setBuildContext(String buildContext) {
        this.buildContext = buildContext;
    }

    public String getDockerfile() {
        return UiUtils.getValue(this.dockerfileTextField);
    }

    public void setDockerfile(String dockerfile) {
        this.dockerfileTextField.setText(dockerfile);
    }

    public Map<String, String> getBuildArgs() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        DefaultTableModel model = (DefaultTableModel)this.buildargsTable.getModel();
        if (this.buildargsTable.isEditing()) {
            this.buildargsTable.getCellEditor().stopCellEditing();
        }
        Iterator<Vector> iterator = model.getDataVector().iterator();
        while (iterator.hasNext()) {
            Vector o;
            Vector v = o = iterator.next();
            String name = (String)v.elementAt(0);
            String value = (String)v.elementAt(1);
            if (name == null || value == null) continue;
            result.put(name, value);
        }
        return result;
    }

    public void setBuildArgs(Map<String, String> buildArgs) {
        DefaultTableModel model = (DefaultTableModel)this.buildargsTable.getModel();
        model.setRowCount(0);
        buildArgs.forEach((key, value) -> model.addRow(new Object[]{key, value}));
    }

    public boolean isPull() {
        return this.pullCheckBox.isSelected();
    }

    public void setPull(boolean pull) {
        this.pullCheckBox.setSelected(pull);
    }

    public boolean isNoCache() {
        return this.noCacheCheckBox.isSelected();
    }

    public void setNoCache(boolean noCache) {
        this.noCacheCheckBox.setSelected(noCache);
    }

    @Override
    public String getName() {
        return Bundle.LBL_BuildOptions();
    }

    private void initComponents() {
        this.dockerfileLabel = new JLabel();
        this.dockerfileTextField = new JTextField();
        this.dockerfileButton = new JButton();
        this.pullCheckBox = new JCheckBox();
        this.noCacheCheckBox = new JCheckBox();
        this.jScrollPane2 = new JScrollPane();
        this.buildargsTable = new JTable();
        this.jLabel1 = new JLabel();
        this.addVariableButton = new JButton();
        this.deleteVariableButton = new JButton();
        this.dockerfileLabel.setLabelFor(this.dockerfileTextField);
        Mnemonics.setLocalizedText((JLabel)this.dockerfileLabel, (String)NbBundle.getMessage(BuildOptionsVisual.class, (String)"BuildOptionsVisual.dockerfileLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.dockerfileButton, (String)NbBundle.getMessage(BuildOptionsVisual.class, (String)"BuildOptionsVisual.dockerfileButton.text"));
        this.dockerfileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BuildOptionsVisual.this.dockerfileButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.pullCheckBox, (String)NbBundle.getMessage(BuildOptionsVisual.class, (String)"BuildOptionsVisual.pullCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.noCacheCheckBox, (String)NbBundle.getMessage(BuildOptionsVisual.class, (String)"BuildOptionsVisual.noCacheCheckBox.text"));
        this.buildargsTable.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Name", "Value"}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.buildargsTable.setSelectionMode(0);
        this.buildargsTable.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BuildOptionsVisual.this.buildargsTablePropertyChange(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.buildargsTable);
        if (this.buildargsTable.getColumnModel().getColumnCount() > 0) {
            this.buildargsTable.getColumnModel().getColumn(0).setHeaderValue(NbBundle.getMessage(BuildOptionsVisual.class, (String)"BuildOptionsVisual.buildargsTable.columnModel.title0"));
            this.buildargsTable.getColumnModel().getColumn(1).setHeaderValue(NbBundle.getMessage(BuildOptionsVisual.class, (String)"BuildOptionsVisual.buildargsTable.columnModel.title1"));
        }
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(BuildOptionsVisual.class, (String)"BuildOptionsVisual.jLabel1.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.addVariableButton, (String)NbBundle.getMessage(BuildOptionsVisual.class, (String)"BuildOptionsVisual.addVariableButton.text"));
        this.addVariableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BuildOptionsVisual.this.addVariableButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.deleteVariableButton, (String)NbBundle.getMessage(BuildOptionsVisual.class, (String)"BuildOptionsVisual.deleteVariableButton.text"));
        this.deleteVariableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BuildOptionsVisual.this.deleteVariableButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.dockerfileLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dockerfileTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dockerfileButton)).addComponent(this.pullCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.noCacheCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane2, -1, 347, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.deleteVariableButton, -2, 94, -2).addComponent(this.addVariableButton, -2, 94, -2))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dockerfileLabel).addComponent(this.dockerfileTextField, -2, -1, -2).addComponent(this.dockerfileButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pullCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.noCacheCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.addVariableButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteVariableButton).addGap(0, 155, Short.MAX_VALUE)))));
    }

    private void dockerfileButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        String dockerText = UiUtils.getValue(this.dockerfileTextField);
        if (dockerText != null) {
            File file = new File(dockerText);
            if (!file.isAbsolute()) {
                file = new File(this.buildContext, dockerText);
            }
            chooser.setSelectedFile(file);
        }
        if (chooser.showOpenDialog(SwingUtilities.getWindowAncestor(this)) == 0) {
            this.dockerfileTextField.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void addVariableButtonActionPerformed(ActionEvent evt) {
        DefaultTableModel model = (DefaultTableModel)this.buildargsTable.getModel();
        model.addRow(new Object[0]);
    }

    private void deleteVariableButtonActionPerformed(ActionEvent evt) {
        DefaultTableModel model = (DefaultTableModel)this.buildargsTable.getModel();
        int selectedRowId = this.buildargsTable.getSelectedRow();
        if (selectedRowId != -1) {
            model.removeRow(selectedRowId);
        }
    }

    private void buildargsTablePropertyChange(PropertyChangeEvent evt) {
    }
}

