/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.identity.model.TagDefaultSummary;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListTagDefaultsRequest
extends BmcRequest<Void> {
    private String page;
    private Integer limit;
    private String id;
    private String compartmentId;
    private String tagDefinitionId;
    private TagDefaultSummary.LifecycleState lifecycleState;

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getTagDefinitionId() {
        return this.tagDefinitionId;
    }

    public TagDefaultSummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Builder toBuilder() {
        return new Builder().page(this.page).limit(this.limit).id(this.id).compartmentId(this.compartmentId).tagDefinitionId(this.tagDefinitionId).lifecycleState(this.lifecycleState);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",tagDefinitionId=").append(String.valueOf(this.tagDefinitionId));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListTagDefaultsRequest)) {
            return false;
        }
        ListTagDefaultsRequest other = (ListTagDefaultsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.tagDefinitionId, other.tagDefinitionId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.tagDefinitionId == null ? 43 : this.tagDefinitionId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListTagDefaultsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String page = null;
        private Integer limit = null;
        private String id = null;
        private String compartmentId = null;
        private String tagDefinitionId = null;
        private TagDefaultSummary.LifecycleState lifecycleState = null;

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder tagDefinitionId(String tagDefinitionId) {
            this.tagDefinitionId = tagDefinitionId;
            return this;
        }

        public Builder lifecycleState(TagDefaultSummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListTagDefaultsRequest o) {
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.id(o.getId());
            this.compartmentId(o.getCompartmentId());
            this.tagDefinitionId(o.getTagDefinitionId());
            this.lifecycleState(o.getLifecycleState());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListTagDefaultsRequest build() {
            ListTagDefaultsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListTagDefaultsRequest buildWithoutInvocationCallback() {
            ListTagDefaultsRequest request = new ListTagDefaultsRequest();
            request.page = this.page;
            request.limit = this.limit;
            request.id = this.id;
            request.compartmentId = this.compartmentId;
            request.tagDefinitionId = this.tagDefinitionId;
            request.lifecycleState = this.lifecycleState;
            return request;
        }
    }
}

