/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wizard;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.modules.xml.util.Util;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class SchemaParser
extends DefaultHandler {
    private SchemaInfo info = new SchemaInfo();
    private int depth = 0;

    public SchemaInfo parse(String sid) {
        if (sid == null) {
            return null;
        }
        return this.parse(new InputSource(sid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaInfo parse(InputSource in) {
        Util.THIS.debug("SchemaParser started.");
        try {
            EntityResolver res;
            this.depth = 0;
            XMLReader parser = XMLUtil.createXMLReader((boolean)false, (boolean)true);
            parser.setContentHandler(this);
            parser.setErrorHandler(this);
            UserCatalog catalog = UserCatalog.getDefault();
            EntityResolver entityResolver = res = catalog == null ? null : catalog.getEntityResolver();
            if (res != null) {
                parser.setEntityResolver(res);
            }
            parser.parse(in);
            SchemaInfo schemaInfo = this.info;
            return schemaInfo;
        }
        catch (SAXException ex) {
            Util.THIS.debug("Ignoring ex. thrown while looking for Schema roots:", ex);
            if (ex.getException() instanceof RuntimeException) {
                Util.THIS.debug("Nested exception:", ex.getException());
            }
            SchemaInfo schemaInfo = this.info;
            return schemaInfo;
        }
        catch (IOException ex) {
            Util.THIS.debug("Ignoring ex. thrown while looking for Schema roots:", ex);
            SchemaInfo schemaInfo = this.info;
            return schemaInfo;
        }
        finally {
            Util.THIS.debug("SchemaParser stopped.");
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String ns;
        ++this.depth;
        if (this.depth > 2) {
            return;
        }
        if ("element".equals(localName)) {
            String root = atts.getValue("name");
            if (root != null) {
                Util.THIS.debug("\telement decl: " + root);
                this.info.roots.add(root);
            }
        } else if ("schema".equals(localName) && (ns = atts.getValue("targetNamespace")) != null) {
            Util.THIS.debug("\ttarget namespace: " + ns);
            this.info.namespace = ns;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        --this.depth;
    }

    public static String getNamespace(FileObject fobj) {
        SchemaParser parser = new SchemaParser();
        File file = FileUtil.toFile((FileObject)fobj);
        SchemaInfo info = parser.parse(file.toURI().toString());
        if (info == null) {
            return null;
        }
        return info.namespace;
    }

    public static SchemaInfo getRootElements(FileObject fobj) {
        SchemaParser parser = new SchemaParser();
        File file = FileUtil.toFile((FileObject)fobj);
        SchemaInfo info = parser.parse(file.toURI().toString());
        if (info == null) {
            return null;
        }
        return info;
    }

    public static final class SchemaInfo {
        public final Set roots = new TreeSet();
        public String namespace;
    }
}

