/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence;

import com.sun.xml.ws.rx.rm.faults.AbstractSoapFaultException;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.runtime.RmRuntimeVersion;
import com.sun.xml.ws.rx.rm.runtime.RuntimeContext;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;

public final class UnknownSequenceException
extends AbstractSoapFaultException {
    private static final long serialVersionUID = 8837409835889666590L;
    private final String sequenceId;

    public UnknownSequenceException(String sequenceId) {
        super(LocalizationMessages.WSRM_1124_NO_SUCH_SEQUENCE_ID_REGISTERED(sequenceId), "The value of wsrm:Identifier is not a known Sequence identifier.", true);
        this.sequenceId = sequenceId;
    }

    public String getSequenceId() {
        return this.sequenceId;
    }

    @Override
    public AbstractSoapFaultException.Code getCode() {
        return AbstractSoapFaultException.Code.Sender;
    }

    @Override
    public QName getSubcode(RmRuntimeVersion rv) {
        return rv.protocolVersion.unknownSequenceFaultCode;
    }

    @Override
    public Detail getDetail(RuntimeContext rc) {
        return new AbstractSoapFaultException.DetailBuilder(rc).addSequenceIdentifier(this.sequenceId).build();
    }
}

