/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.facet.iterators;

import java.io.IOException;
import org.apache.lucene.sandbox.facet.iterators.OrdinalIterator;

public final class LengthOrdinalIterator
implements OrdinalIterator {
    private final OrdinalIterator delegate;
    private boolean complete;
    private int length;

    public LengthOrdinalIterator(OrdinalIterator delegate) throws IOException {
        this.delegate = delegate;
    }

    public int length() {
        if (this.complete) {
            return this.length;
        }
        throw new IllegalStateException("You can't request count before the ordinal iterator was consumed");
    }

    @Override
    public int nextOrd() throws IOException {
        int ord = this.delegate.nextOrd();
        if (ord == -1) {
            this.complete = true;
        } else {
            ++this.length;
        }
        return ord;
    }
}

