# Gauss, single 4
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("gauss04.tst");

# doc/../gap/Sparse.gi:103-157
gap> M := [[1,0,1],[1,1,0],[1,0,1],[1,1,0],[1,1,1]] * One( GF(2) );;
gap> EchelonMatTransformation( M );
rec( 
  coeffs := [ <an immutable GF2 vector of length 5>,
      <an immutable GF2 vector of length 5>, 
      <an immutable GF2 vector of length 5> ], heads := [ 1, 2, 3 ], 
  relations := 
    [ <an immutable GF2 vector of length 5>,
      <an immutable GF2 vector of length 5> ], 
  vectors := [ <an immutable GF2 vector of length 3>,
      <an immutable GF2 vector of length 3>,
      <an immutable GF2 vector of length 3> ] )
gap> Display(last.vectors);
 1 . .
 . 1 .
 . . 1
gap> Display(last.coeffs);
 1 1 . . 1
 1 . . . 1
 . 1 . . 1
gap> Display(last.relations);
 1 . 1 . .
 . 1 . 1 .
gap> Display( Concatenation( last.coeffs, last.relations ) * M );
 1 . .
 . 1 .
 . . 1
 . . .
 . . .
gap> SM := SparseMatrix( M );
<a 5 x 3 sparse matrix over GF(2)>
gap> EchelonMatTransformation( SM );
rec( coeffs := <a 3 x 5 sparse matrix over GF(2)>, 
  heads := [ 1, 2, 3 ], 
  relations := <a 2 x 5 sparse matrix over GF(2)>, 
  vectors := <a 3 x 3 sparse matrix over GF(2)> )
gap> Display(last.vectors);
 1 . .
 . 1 .
 . . 1
gap> Display(last.coeffs);
 1 1 . . 1
 1 . . . 1
 . 1 . . 1
gap> Display(last.relations);
 1 . 1 . .
 . 1 . 1 .
gap> Display( SparseUnionOfRows( [ last.coeffs, last.relations ] ) * SM );
 1 . .
 . 1 .
 . . 1
 . . .
 . . .

#
gap> STOP_TEST("gauss04.tst", 1);
