/**
 * SECTION:alias-details
 * @short_description: Alias for a contact.
 * 
 * <para>This allows representation of aliases for contacts, where the user has chosen their own name for the contact to better represent that contact to them. A typical example of this is the use of user-chosen aliases for contacts in instant messaging programs.</para>
 */
/**
 * folks_alias_details_change_alias:
 * @self: the <link linkend="FolksAliasDetails"><type>FolksAliasDetails</type></link> instance
 * @alias: (in): &nbsp;.  <para>the new alias </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Change the contact&apos;s alias.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksAliasDetails--alias"><type>"alias"</type></link> directly, as this method gives error notification and will only return once the alias has been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the alias failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-alias-details-change-alias-finish"><function>folks_alias_details_change_alias_finish()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * folks_alias_details_change_alias_finish:
 * @self: the <link linkend="FolksAliasDetails"><type>FolksAliasDetails</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPropertyError): location to store the error occurring, or %NULL to ignore
 * 
 * Change the contact&apos;s alias.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksAliasDetails--alias"><type>"alias"</type></link> directly, as this method gives error notification and will only return once the alias has been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the alias failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-alias-details-change-alias"><function>folks_alias_details_change_alias()</function></link>
 *
 * Since: 0.6.2
 */
/**
 * FolksAliasDetails:alias:
 * 
 * An alias for the contact.
 * 
 * <para>An alias is a user-given name, to be used in UIs as the sole way to represent the contact to the user.</para><para>This may not be <code>null</code>: an empty string represents an unset alias.</para>
 */
/**
 * folks_alias_details_get_alias:
 * @self: the <link linkend="FolksAliasDetails"><type>FolksAliasDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksAliasDetails--alias"><type>"alias"</type></link> property.
 * 
 * An alias for the contact.
 * 
 * <para>An alias is a user-given name, to be used in UIs as the sole way to represent the contact to the user.</para><para>This may not be <code>null</code>: an empty string represents an unset alias.</para>
 * 
 * Returns: the value of the <link linkend="FolksAliasDetails--alias"><type>"alias"</type></link> property
 */
/**
 * folks_alias_details_set_alias:
 * @self: the <link linkend="FolksAliasDetails"><type>FolksAliasDetails</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksAliasDetails--alias"><type>"alias"</type></link> property
 * 
 * Set the value of the <link linkend="FolksAliasDetails--alias"><type>"alias"</type></link> property to @value.
 * 
 * An alias for the contact.
 * 
 * <para>An alias is a user-given name, to be used in UIs as the sole way to represent the contact to the user.</para><para>This may not be <code>null</code>: an empty string represents an unset alias.</para>
 */
/**
 * FolksAliasDetails:
 * 
 * Alias for a contact.
 * 
 * <para>This allows representation of aliases for contacts, where the user has chosen their own name for the contact to better represent that contact to them. A typical example of this is the use of user-chosen aliases for contacts in instant messaging programs.</para>
 */
/**
 * FolksAliasDetailsIface:
 * @change_alias: virtual method called by <link linkend="folks-alias-details-change-alias"><function>folks_alias_details_change_alias()</function></link>
 * @change_alias_finish: asynchronous finish function for <structfield>change_alias</structfield>, called by <link linkend="folks-alias-details-change-alias"><function>folks_alias_details_change_alias()</function></link>
 * @get_alias: getter method for the abstract property <link linkend="FolksAliasDetails--alias"><type>"alias"</type></link>
 * @set_alias: setter method for the abstract property <link linkend="FolksAliasDetails--alias"><type>"alias"</type></link>
 * @parent_iface: the parent interface structure
 * 
 * Interface for creating <link linkend="FolksAliasDetails"><type>FolksAliasDetails</type></link> implementations.
 */
