/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.spark;

import java.util.Properties;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.spark.SparkVersion;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    Utils() {
    }

    public static String buildJobGroupId(InterpreterContext context) {
        String uName = "anonymous";
        if (context.getAuthenticationInfo() != null) {
            uName = Utils.getUserName(context.getAuthenticationInfo());
        }
        return "zeppelin|" + uName + "|" + context.getNoteId() + "|" + context.getParagraphId();
    }

    public static String buildJobDesc(InterpreterContext context) {
        return "Started by: " + Utils.getUserName(context.getAuthenticationInfo());
    }

    public static String getUserName(AuthenticationInfo info) {
        String uName = "";
        if (info != null) {
            uName = info.getUser();
        }
        if (uName == null || uName.isEmpty()) {
            uName = "anonymous";
        }
        return uName;
    }

    public static void printDeprecateMessage(SparkVersion sparkVersion, InterpreterContext context, Properties properties) throws InterpreterException {
        context.out.clear();
    }
}

