/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.launcher;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import java.util.concurrent.CountDownLatch;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodPhaseWatcher
implements Watcher<Pod> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PodPhaseWatcher.class);
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private final Predicate<String> predicate;

    public PodPhaseWatcher(Predicate<String> predicate) {
        this.predicate = predicate;
    }

    @Override
    public void eventReceived(Watcher.Action action, Pod pod) {
        PodStatus status = pod.getStatus();
        if (status != null && this.predicate.test(status.getPhase())) {
            LOGGER.info("Pod {} meets phase {}", (Object)pod.getMetadata().getName(), (Object)status.getPhase());
            this.countDownLatch.countDown();
        }
    }

    @Override
    public void onClose(WatcherException cause) {
        if (cause != null) {
            LOGGER.error("PodWatcher exits abnormally", cause);
        }
        this.countDownLatch.countDown();
    }

    @Override
    public void onClose() {
        this.countDownLatch.countDown();
    }

    public CountDownLatch getCountDownLatch() {
        return this.countDownLatch;
    }
}

