/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.util.ArrayList;
import java.util.List;

public enum InterpreterPropertyType {
    TEXTAREA("textarea"),
    STRING("string"),
    NUMBER("number"),
    URL("url"),
    PASSWORD("password"),
    CHECKBOX("checkbox");

    private String value;

    private InterpreterPropertyType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static InterpreterPropertyType byValue(String value) {
        for (InterpreterPropertyType e : InterpreterPropertyType.values()) {
            if (!e.getValue().equals(value)) continue;
            return e;
        }
        return null;
    }

    public static List<String> getTypes() {
        InterpreterPropertyType[] values;
        ArrayList<String> types = new ArrayList<String>();
        for (InterpreterPropertyType interpreterPropertyType : values = InterpreterPropertyType.values()) {
            types.add(interpreterPropertyType.getValue());
        }
        return types;
    }
}

