/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.flink.sql;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.StringUtils;
import org.apache.zeppelin.flink.FlinkShims;
import org.apache.zeppelin.flink.JobManager;
import org.apache.zeppelin.flink.sql.AbstractStreamSqlJob;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.tabledata.TableDataUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateStreamSqlJob
extends AbstractStreamSqlJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateStreamSqlJob.class);
    private List<Row> materializedTable = new ArrayList<Row>();
    private List<Row> lastSnapshot = new ArrayList<Row>();

    public UpdateStreamSqlJob(StreamExecutionEnvironment senv, TableEnvironment stEnv, JobManager jobManager, InterpreterContext context, int defaultParallelism, FlinkShims flinkShims) {
        super(senv, stEnv, jobManager, context, defaultParallelism, flinkShims);
    }

    @Override
    protected String getType() {
        return "retract";
    }

    @Override
    protected void processInsert(Row row) {
        this.enableToRefresh = true;
        this.resultLock.notify();
        LOGGER.debug("processInsert: {}", (Object)row);
        this.materializedTable.add(row);
    }

    @Override
    protected void processDelete(Row row) {
        this.enableToRefresh = false;
        LOGGER.debug("processDelete: {}", (Object)row);
        for (int i = 0; i < this.materializedTable.size(); ++i) {
            if (!this.flinkShims.rowEquals(this.materializedTable.get(i), row)) continue;
            LOGGER.debug("real processDelete: {}", (Object)row);
            this.materializedTable.remove(i);
            break;
        }
    }

    @Override
    protected String buildResult() {
        StringBuilder builder = new StringBuilder();
        builder.append("%table\n");
        for (int i = 0; i < this.schema.getFieldCount(); ++i) {
            String field = this.schema.getFieldNames()[i];
            builder.append(field);
            if (i == this.schema.getFieldCount() - 1) continue;
            builder.append("\t");
        }
        builder.append("\n");
        this.materializedTable.sort((r1, r2) -> {
            String f1 = TableDataUtils.normalizeColumn((String)StringUtils.arrayAwareToString((Object)r1.getField(0)));
            String f2 = TableDataUtils.normalizeColumn((String)StringUtils.arrayAwareToString((Object)r2.getField(0)));
            return f1.compareTo(f2);
        });
        builder.append(this.tableToString(this.materializedTable));
        builder.append("\n%text\n");
        return builder.toString();
    }

    @Override
    protected void refresh(InterpreterContext context) {
        context.out().clear(false);
        try {
            String result = this.buildResult();
            context.out.write(result);
            context.out.flush();
            LOGGER.debug("Refresh with data: {}", (Object)result);
            this.lastSnapshot.clear();
            for (Row row : this.materializedTable) {
                this.lastSnapshot.add(row);
            }
        }
        catch (IOException e) {
            LOGGER.error("Fail to refresh data", e);
        }
    }
}

