/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.flink.internal;

import java.io.BufferedReader;
import java.io.Serializable;
import java.net.URI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.flink.annotation.Internal;
import org.apache.flink.client.cli.CliFrontend;
import org.apache.flink.client.cli.CliFrontendParser;
import org.apache.flink.client.deployment.ClusterClientFactory;
import org.apache.flink.client.deployment.ClusterDescriptor;
import org.apache.flink.client.deployment.ClusterSpecification;
import org.apache.flink.client.deployment.DefaultClusterClientServiceLoader;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.MiniClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import org.apache.zeppelin.flink.FlinkShims;
import org.apache.zeppelin.flink.internal.FlinkShell;
import org.apache.zeppelin.flink.internal.FlinkShell$ExecutionMode$;
import org.apache.zeppelin.flink.internal.FlinkShell$YarnConfig$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class FlinkShell$ {
    public static FlinkShell$ MODULE$;
    private Option<BufferedReader> bufferedReader;

    static {
        new FlinkShell$();
    }

    public Option<BufferedReader> bufferedReader() {
        return this.bufferedReader;
    }

    public void bufferedReader_$eq(Option<BufferedReader> x$1) {
        this.bufferedReader = x$1;
    }

    @Internal
    public FlinkShell.YarnConfig ensureYarnConfig(FlinkShell.Config config) {
        FlinkShell.YarnConfig yarnConfig;
        Option<FlinkShell.YarnConfig> option = config.yarnConfig();
        if (option instanceof Some) {
            FlinkShell.YarnConfig yarnConfig2;
            Some some = (Some)option;
            yarnConfig = yarnConfig2 = (FlinkShell.YarnConfig)some.value();
        } else if (None$.MODULE$.equals(option)) {
            yarnConfig = new FlinkShell.YarnConfig(FlinkShell$YarnConfig$.MODULE$.apply$default$1(), FlinkShell$YarnConfig$.MODULE$.apply$default$2(), FlinkShell$YarnConfig$.MODULE$.apply$default$3(), FlinkShell$YarnConfig$.MODULE$.apply$default$4(), FlinkShell$YarnConfig$.MODULE$.apply$default$5());
        } else {
            throw new MatchError(option);
        }
        return yarnConfig;
    }

    private String getConfigDir(FlinkShell.Config config) {
        return (String)config.configDir().getOrElse((Function0 & Serializable & scala.Serializable)() -> CliFrontend.getConfigurationDirectoryFromEnv());
    }

    @Internal
    public Tuple2<Configuration, Option<ClusterClient<?>>> fetchConnectionInfo(FlinkShell.Config config, Configuration flinkConfig, FlinkShims flinkShims) {
        Tuple2 tuple2;
        Enumeration.Value value = config.executionMode();
        Enumeration.Value value2 = FlinkShell$ExecutionMode$.MODULE$.LOCAL();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            tuple2 = this.createLocalClusterAndConfig(flinkConfig);
        } else {
            Enumeration.Value value4 = FlinkShell$ExecutionMode$.MODULE$.REMOTE();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                tuple2 = this.createRemoteConfig(config, flinkConfig);
            } else {
                Enumeration.Value value6 = FlinkShell$ExecutionMode$.MODULE$.YARN();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    tuple2 = this.createYarnClusterIfNeededAndGetConfig(config, flinkConfig, flinkShims);
                } else {
                    Enumeration.Value value8 = FlinkShell$ExecutionMode$.MODULE$.YARN_APPLICATION();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        tuple2 = new Tuple2((Object)flinkConfig, (Object)None$.MODULE$);
                    } else {
                        Enumeration.Value value10 = FlinkShell$ExecutionMode$.MODULE$.KUBERNETES_APPLICATION();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            tuple2 = new Tuple2((Object)flinkConfig, (Object)None$.MODULE$);
                        } else {
                            Enumeration.Value value12 = FlinkShell$ExecutionMode$.MODULE$.UNDEFINED();
                            Enumeration.Value value13 = value;
                            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                throw new IllegalArgumentException("please specify execution mode:\n[local | remote <host> <port> | yarn | yarn-application | kubernetes-application]");
                            }
                            throw new MatchError((Object)value);
                        }
                    }
                }
            }
        }
        return tuple2;
    }

    private Tuple2<Configuration, Option<ClusterClient<Nothing$>>> createYarnClusterIfNeededAndGetConfig(FlinkShell.Config config, Configuration flinkConfig, FlinkShims flinkShims) {
        Configuration effectiveConfig;
        Tuple2<Configuration, None$> tuple2;
        Option clusterClient;
        Tuple2 tuple22;
        flinkConfig.setBoolean(DeploymentOptions.ATTACHED, true);
        Option<FlinkShell.YarnConfig> option = config.yarnConfig();
        if (option instanceof Some) {
            tuple22 = this.deployNewYarnCluster(config, flinkConfig, flinkShims);
        } else if (None$.MODULE$.equals(option)) {
            tuple22 = new Tuple2((Object)flinkConfig, (Object)None$.MODULE$);
        } else {
            throw new MatchError(option);
        }
        Tuple2 tuple23 = tuple22;
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        Configuration clusterConfig = (Configuration)tuple23._1();
        Option clusterClient2 = (Option)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)clusterConfig, (Object)clusterClient2);
        Tuple2 tuple25 = tuple24;
        Configuration clusterConfig2 = (Configuration)tuple25._1();
        Option option2 = clusterClient = (Option)tuple25._2();
        if (option2 instanceof Some) {
            tuple2 = this.fetchDeployedYarnClusterInfo(config, clusterConfig2, "yarn-cluster", flinkShims);
        } else if (None$.MODULE$.equals(option2)) {
            tuple2 = this.fetchDeployedYarnClusterInfo(config, clusterConfig2, "default", flinkShims);
        } else {
            throw new MatchError((Object)option2);
        }
        Tuple2<Configuration, None$> tuple26 = tuple2;
        if (tuple26 == null) {
            throw new MatchError(tuple26);
        }
        Configuration configuration = effectiveConfig = (Configuration)tuple26._1();
        Configuration effectiveConfig2 = configuration;
        Predef$.MODULE$.println((Object)new StringBuilder(15).append("Configuration: ").append(effectiveConfig2).toString());
        return new Tuple2((Object)effectiveConfig2, (Object)clusterClient);
    }

    private Tuple2<Configuration, Some<ClusterClient<Nothing$>>> deployNewYarnCluster(FlinkShell.Config config, Configuration flinkConfig, FlinkShims flinkShims) {
        ClusterClient clusterClient;
        Configuration effectiveConfig = new Configuration(flinkConfig);
        String[] args = this.parseArgList(config, "yarn-cluster");
        String configurationDirectory = this.getConfigDir(config);
        CliFrontend frontend = new CliFrontend(effectiveConfig, CliFrontend.loadCustomCommandLines((Configuration)effectiveConfig, (String)configurationDirectory));
        Options commandOptions = CliFrontendParser.getRunCommandOptions();
        Options commandLineOptions = CliFrontendParser.mergeOptions((Options)commandOptions, (Options)frontend.getCustomCommandLineOptions());
        CommandLine commandLine = CliFrontendParser.parse((Options)commandLineOptions, (String[])args, (boolean)true);
        effectiveConfig = (Configuration)flinkShims.updateEffectiveConfig(frontend, commandLine, effectiveConfig);
        DefaultClusterClientServiceLoader serviceLoader = new DefaultClusterClientServiceLoader();
        ClusterClientFactory clientFactory = serviceLoader.getClusterClientFactory(effectiveConfig);
        ClusterDescriptor clusterDescriptor = clientFactory.createClusterDescriptor(effectiveConfig);
        ClusterSpecification clusterSpecification = clientFactory.getClusterSpecification(effectiveConfig);
        try {
            clusterClient = clusterDescriptor.deploySessionCluster(clusterSpecification).getClusterClient();
        }
        finally {
            effectiveConfig.set(DeploymentOptions.TARGET, (Object)"yarn-session");
            clusterDescriptor.close();
        }
        ClusterClient clusterClient2 = clusterClient;
        return new Tuple2((Object)effectiveConfig, (Object)new Some((Object)clusterClient2));
    }

    private Tuple2<Configuration, None$> fetchDeployedYarnClusterInfo(FlinkShell.Config config, Configuration flinkConfig, String mode, FlinkShims flinkShims) {
        Configuration effectiveConfig = new Configuration(flinkConfig);
        String[] args = this.parseArgList(config, mode);
        String configurationDirectory = this.getConfigDir(config);
        CliFrontend frontend = new CliFrontend(effectiveConfig, CliFrontend.loadCustomCommandLines((Configuration)effectiveConfig, (String)configurationDirectory));
        Options commandOptions = CliFrontendParser.getRunCommandOptions();
        Options commandLineOptions = CliFrontendParser.mergeOptions((Options)commandOptions, (Options)frontend.getCustomCommandLineOptions());
        CommandLine commandLine = CliFrontendParser.parse((Options)commandLineOptions, (String[])args, (boolean)true);
        effectiveConfig = (Configuration)flinkShims.updateEffectiveConfig(frontend, commandLine, effectiveConfig);
        return new Tuple2((Object)effectiveConfig, (Object)None$.MODULE$);
    }

    public String[] parseArgList(FlinkShell.Config config, String mode) {
        String[] stringArray;
        String string = mode;
        String string2 = "default";
        ArrayBuffer args = !(string != null ? !string.equals(string2) : string2 != null) ? (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$) : (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-m", mode}));
        Option<FlinkShell.YarnConfig> option = config.yarnConfig();
        if (option instanceof Some) {
            Some some = (Some)option;
            FlinkShell.YarnConfig yarnConfig = (FlinkShell.YarnConfig)some.value();
            yarnConfig.jobManagerMemory().foreach((Function1 & Serializable & scala.Serializable)jmMem -> args.$plus$plus$eq((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-yjm", jmMem.toString()}))));
            yarnConfig.taskManagerMemory().foreach((Function1 & Serializable & scala.Serializable)tmMem -> args.$plus$plus$eq((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-ytm", tmMem.toString()}))));
            yarnConfig.name().foreach((Function1 & Serializable & scala.Serializable)name -> args.$plus$plus$eq((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-ynm", name.toString()}))));
            yarnConfig.queue().foreach((Function1 & Serializable & scala.Serializable)queue -> args.$plus$plus$eq((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-yqu", queue.toString()}))));
            yarnConfig.slots().foreach((Function1 & Serializable & scala.Serializable)slots -> args.$plus$plus$eq((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-ys", ((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)slots))).toString()}))));
            stringArray = (String[])args.toArray(ClassTag$.MODULE$.apply(String.class));
        } else if (None$.MODULE$.equals(option)) {
            stringArray = (String[])args.toArray(ClassTag$.MODULE$.apply(String.class));
        } else {
            throw new MatchError(option);
        }
        return stringArray;
    }

    private Tuple2<Configuration, None$> createRemoteConfig(FlinkShell.Config config, Configuration flinkConfig) {
        if (config.host().isEmpty() || config.port().isEmpty()) {
            throw new IllegalArgumentException("<host> or <port> is not specified!");
        }
        Configuration effectiveConfig = new Configuration(flinkConfig);
        this.setJobManagerInfoToConfig(effectiveConfig, (String)config.host().get(), Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)config.port().get())));
        effectiveConfig.set(DeploymentOptions.TARGET, (Object)"remote");
        effectiveConfig.setBoolean(DeploymentOptions.ATTACHED, true);
        return new Tuple2((Object)effectiveConfig, (Object)None$.MODULE$);
    }

    private Tuple2<Configuration, Some<MiniClusterClient>> createLocalClusterAndConfig(Configuration flinkConfig) {
        Configuration config = new Configuration(flinkConfig);
        config.setInteger(JobManagerOptions.PORT, 0);
        MiniCluster cluster = this.createLocalCluster(config);
        int port = ((URI)cluster.getRestAddress().get()).getPort();
        this.setJobManagerInfoToConfig(config, "localhost", Predef$.MODULE$.int2Integer(port));
        config.set(DeploymentOptions.TARGET, (Object)"remote");
        config.setBoolean(DeploymentOptions.ATTACHED, true);
        Predef$.MODULE$.println((Object)new StringBuilder(57).append("\nStarting local Flink cluster (host: localhost, port: ").append(port).append(").\n").toString());
        MiniClusterClient clusterClient = new MiniClusterClient(config, cluster);
        return new Tuple2((Object)config, (Object)new Some((Object)clusterClient));
    }

    private MiniCluster createLocalCluster(Configuration flinkConfig) {
        int numTaskManagers = flinkConfig.getInteger("local.number-taskmanager", 1);
        int numSlotsPerTaskManager = flinkConfig.getInteger(TaskManagerOptions.NUM_TASK_SLOTS);
        MiniClusterConfiguration miniClusterConfig = new MiniClusterConfiguration.Builder().setConfiguration(flinkConfig).setNumSlotsPerTaskManager(numSlotsPerTaskManager).setNumTaskManagers(numTaskManagers).build();
        MiniCluster cluster = new MiniCluster(miniClusterConfig);
        cluster.start();
        return cluster;
    }

    private void setJobManagerInfoToConfig(Configuration config, String host, Integer port) {
        config.setString(JobManagerOptions.ADDRESS, host);
        config.setInteger(JobManagerOptions.PORT, Predef$.MODULE$.Integer2int(port));
        config.setString(RestOptions.ADDRESS, host);
        config.setInteger(RestOptions.PORT, Predef$.MODULE$.Integer2int(port));
    }

    private FlinkShell$() {
        MODULE$ = this;
        this.bufferedReader = None$.MODULE$;
    }
}

