/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.flink;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.module.ModuleManager;
import org.apache.zeppelin.flink.FlinkShims;
import org.apache.zeppelin.flink.FlinkVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableEnvFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableEnvFactory.class);
    private FlinkVersion flinkVersion;
    private FlinkShims flinkShims;
    private org.apache.flink.api.scala.ExecutionEnvironment benv;
    private StreamExecutionEnvironment senv;
    private List<URL> userJars;
    private TableConfig streamTableConfig;
    private TableConfig batchTableConfig;
    private TableConfig oldPlannerStreamTableConfig;
    private TableConfig oldPlannerBatchTableConfig;
    private CatalogManager catalogManager;
    private CatalogManager oldPlannerCatalogManager;
    private ModuleManager moduleManager;
    private FunctionCatalog functionCatalog;

    public TableEnvFactory(FlinkVersion flinkVersion, FlinkShims flinkShims, org.apache.flink.api.scala.ExecutionEnvironment env, StreamExecutionEnvironment senv, TableConfig streamTableConfig, List<URL> userJars) {
        this.flinkVersion = flinkVersion;
        this.flinkShims = flinkShims;
        this.benv = env;
        this.senv = senv;
        this.streamTableConfig = streamTableConfig;
        this.batchTableConfig = new TableConfig();
        this.batchTableConfig.getConfiguration().addAll(streamTableConfig.getConfiguration());
        flinkShims.setBatchRuntimeMode(this.batchTableConfig);
        this.oldPlannerBatchTableConfig = new TableConfig();
        this.oldPlannerBatchTableConfig.getConfiguration().addAll(streamTableConfig.getConfiguration());
        flinkShims.setOldPlanner(this.oldPlannerBatchTableConfig);
        this.oldPlannerStreamTableConfig = new TableConfig();
        this.oldPlannerStreamTableConfig.getConfiguration().addAll(streamTableConfig.getConfiguration());
        flinkShims.setOldPlanner(this.oldPlannerStreamTableConfig);
        this.catalogManager = (CatalogManager)flinkShims.createCatalogManager(streamTableConfig.getConfiguration());
        this.oldPlannerCatalogManager = (CatalogManager)flinkShims.createCatalogManager(this.oldPlannerStreamTableConfig.getConfiguration());
        this.moduleManager = new ModuleManager();
        this.functionCatalog = (FunctionCatalog)flinkShims.createFunctionCatalog(streamTableConfig, this.catalogManager, this.moduleManager, userJars);
        this.userJars = userJars;
    }

    public TableEnvironment createScalaFlinkBatchTableEnvironment() {
        try {
            Class<?> clazz = Class.forName("org.apache.flink.table.api.bridge.scala.internal.BatchTableEnvironmentImpl");
            Constructor<?> constructor = clazz.getConstructor(org.apache.flink.api.scala.ExecutionEnvironment.class, TableConfig.class, CatalogManager.class, ModuleManager.class);
            return (TableEnvironment)constructor.newInstance(this.benv, this.oldPlannerBatchTableConfig, this.oldPlannerCatalogManager, this.moduleManager);
        }
        catch (Exception e) {
            throw new TableException("Fail to createScalaFlinkBatchTableEnvironment", (Throwable)e);
        }
    }

    public TableEnvironment createJavaFlinkBatchTableEnvironment() {
        try {
            Class<?> clazz = Class.forName("org.apache.flink.table.api.bridge.java.internal.BatchTableEnvironmentImpl");
            Constructor<?> con = clazz.getConstructor(ExecutionEnvironment.class, TableConfig.class, CatalogManager.class, ModuleManager.class);
            return (TableEnvironment)con.newInstance(this.benv.getJavaEnv(), this.oldPlannerBatchTableConfig, this.oldPlannerCatalogManager, this.moduleManager);
        }
        catch (Throwable t) {
            throw new TableException("Create BatchTableEnvironment failed.", t);
        }
    }

    public TableEnvironment createScalaBlinkStreamTableEnvironment(EnvironmentSettings settings, ClassLoader classLoader) {
        return (TableEnvironment)this.flinkShims.createScalaBlinkStreamTableEnvironment(settings, this.senv.getJavaEnv(), this.streamTableConfig, this.moduleManager, this.functionCatalog, this.catalogManager, this.userJars, classLoader);
    }

    public TableEnvironment createJavaBlinkStreamTableEnvironment(EnvironmentSettings settings, ClassLoader classLoader) {
        return (TableEnvironment)this.flinkShims.createJavaBlinkStreamTableEnvironment(settings, this.senv.getJavaEnv(), this.streamTableConfig, this.moduleManager, this.functionCatalog, this.catalogManager, this.userJars, classLoader);
    }

    public TableEnvironment createJavaBlinkBatchTableEnvironment(EnvironmentSettings settings, ClassLoader classLoader) {
        return (TableEnvironment)this.flinkShims.createJavaBlinkStreamTableEnvironment(settings, this.senv.getJavaEnv(), this.batchTableConfig, this.moduleManager, this.functionCatalog, this.catalogManager, this.userJars, classLoader);
    }

    public void createStreamPlanner(EnvironmentSettings settings) {
        ImmutablePair<Object, Object> pair = this.flinkShims.createPlannerAndExecutor(Thread.currentThread().getContextClassLoader(), settings, this.senv.getJavaEnv(), this.streamTableConfig, this.moduleManager, this.functionCatalog, this.catalogManager);
        Planner planner = (Planner)pair.left;
        this.flinkShims.setCatalogManagerSchemaResolver(this.catalogManager, planner.getParser(), settings);
    }
}

