/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.flink;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.types.Row;
import org.apache.flink.util.StringUtils;
import org.apache.zeppelin.flink.TimestampStringUtils;

public class PrintUtils {
    public static final String NULL_COLUMN = "(NULL)";
    private static final String COLUMN_TRUNCATED_FLAG = "...";

    private PrintUtils() {
    }

    public static String[] rowToString(Row row, ResolvedSchema resolvedSchema, ZoneId sessionTimeZone) {
        return PrintUtils.rowToString(row, NULL_COLUMN, false, resolvedSchema, sessionTimeZone);
    }

    public static String[] rowToString(Row row, String nullColumn, boolean printRowKind, ResolvedSchema resolvedSchema, ZoneId sessionTimeZone) {
        int len = printRowKind ? row.getArity() + 1 : row.getArity();
        ArrayList<String> fields = new ArrayList<String>(len);
        if (printRowKind) {
            fields.add(row.getKind().shortString());
        }
        for (int i = 0; i < row.getArity(); ++i) {
            Object field = row.getField(i);
            LogicalType fieldType = ((DataType)resolvedSchema.getColumnDataTypes().get(i)).getLogicalType();
            if (field == null) {
                fields.add(nullColumn);
                continue;
            }
            fields.add(StringUtils.arrayAwareToString((Object)PrintUtils.formattedTimestamp(field, fieldType, sessionTimeZone)));
        }
        return fields.toArray(new String[0]);
    }

    private static Object formattedTimestamp(Object field, LogicalType fieldType, ZoneId sessionTimeZone) {
        LogicalTypeRoot typeRoot = fieldType.getTypeRoot();
        if (field == null) {
            return "null";
        }
        switch (typeRoot) {
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return PrintUtils.formatTimestampField(field, fieldType, sessionTimeZone);
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return PrintUtils.formatTimeField(field);
            }
            case ARRAY: {
                LogicalType elementType = ((ArrayType)fieldType).getElementType();
                if (field instanceof List) {
                    List array = (List)field;
                    Object[] formattedArray = new Object[array.size()];
                    for (int i = 0; i < array.size(); ++i) {
                        formattedArray[i] = PrintUtils.formattedTimestamp(array.get(i), elementType, sessionTimeZone);
                    }
                    return formattedArray;
                }
                if (field.getClass().isArray()) {
                    if (field.getClass() == byte[].class) {
                        byte[] array = (byte[])field;
                        Object[] formattedArray = new Object[array.length];
                        for (int i = 0; i < array.length; ++i) {
                            formattedArray[i] = PrintUtils.formattedTimestamp(array[i], elementType, sessionTimeZone);
                        }
                        return formattedArray;
                    }
                    if (field.getClass() == short[].class) {
                        short[] array = (short[])field;
                        Object[] formattedArray = new Object[array.length];
                        for (int i = 0; i < array.length; ++i) {
                            formattedArray[i] = PrintUtils.formattedTimestamp(array[i], elementType, sessionTimeZone);
                        }
                        return formattedArray;
                    }
                    if (field.getClass() == int[].class) {
                        int[] array = (int[])field;
                        Object[] formattedArray = new Object[array.length];
                        for (int i = 0; i < array.length; ++i) {
                            formattedArray[i] = PrintUtils.formattedTimestamp(array[i], elementType, sessionTimeZone);
                        }
                        return formattedArray;
                    }
                    if (field.getClass() == long[].class) {
                        long[] array = (long[])field;
                        Object[] formattedArray = new Object[array.length];
                        for (int i = 0; i < array.length; ++i) {
                            formattedArray[i] = PrintUtils.formattedTimestamp(array[i], elementType, sessionTimeZone);
                        }
                        return formattedArray;
                    }
                    if (field.getClass() == float[].class) {
                        float[] array = (float[])field;
                        Object[] formattedArray = new Object[array.length];
                        for (int i = 0; i < array.length; ++i) {
                            formattedArray[i] = PrintUtils.formattedTimestamp(Float.valueOf(array[i]), elementType, sessionTimeZone);
                        }
                        return formattedArray;
                    }
                    if (field.getClass() == double[].class) {
                        double[] array = (double[])field;
                        Object[] formattedArray = new Object[array.length];
                        for (int i = 0; i < array.length; ++i) {
                            formattedArray[i] = PrintUtils.formattedTimestamp(array[i], elementType, sessionTimeZone);
                        }
                        return formattedArray;
                    }
                    if (field.getClass() == boolean[].class) {
                        boolean[] array = (boolean[])field;
                        Object[] formattedArray = new Object[array.length];
                        for (int i = 0; i < array.length; ++i) {
                            formattedArray[i] = PrintUtils.formattedTimestamp(array[i], elementType, sessionTimeZone);
                        }
                        return formattedArray;
                    }
                    if (field.getClass() == char[].class) {
                        char[] array = (char[])field;
                        Object[] formattedArray = new Object[array.length];
                        for (int i = 0; i < array.length; ++i) {
                            formattedArray[i] = PrintUtils.formattedTimestamp(Character.valueOf(array[i]), elementType, sessionTimeZone);
                        }
                        return formattedArray;
                    }
                    Object[] array = (Object[])field;
                    Object[] formattedArray = new Object[array.length];
                    for (int i = 0; i < array.length; ++i) {
                        formattedArray[i] = PrintUtils.formattedTimestamp(array[i], elementType, sessionTimeZone);
                    }
                    return formattedArray;
                }
                return field;
            }
            case ROW: {
                if (fieldType instanceof RowType && field instanceof Row) {
                    Row row = (Row)field;
                    Row formattedRow = new Row(row.getKind(), row.getArity());
                    for (int i = 0; i < ((RowType)fieldType).getFields().size(); ++i) {
                        LogicalType type = ((RowType.RowField)((RowType)fieldType).getFields().get(i)).getType();
                        formattedRow.setField(i, PrintUtils.formattedTimestamp(row.getField(i), type, sessionTimeZone));
                    }
                    return formattedRow;
                }
                if (fieldType instanceof RowType && field instanceof RowData) {
                    RowData rowData = (RowData)field;
                    Row formattedRow = new Row(rowData.getRowKind(), rowData.getArity());
                    for (int i = 0; i < ((RowType)fieldType).getFields().size(); ++i) {
                        LogicalType type = ((RowType.RowField)((RowType)fieldType).getFields().get(i)).getType();
                        RowData.FieldGetter fieldGetter = RowData.createFieldGetter((LogicalType)type, (int)i);
                        formattedRow.setField(i, PrintUtils.formattedTimestamp(fieldGetter.getFieldOrNull(rowData), type, sessionTimeZone));
                    }
                    return formattedRow;
                }
                return field;
            }
            case MAP: {
                LogicalType keyType = ((MapType)fieldType).getKeyType();
                LogicalType valueType = ((MapType)fieldType).getValueType();
                if (fieldType instanceof MapType && field instanceof Map) {
                    Map map = (Map)field;
                    HashMap<Object, Object> formattedMap = new HashMap<Object, Object>(map.size());
                    for (Object key : map.keySet()) {
                        formattedMap.put(PrintUtils.formattedTimestamp(key, keyType, sessionTimeZone), PrintUtils.formattedTimestamp(map.get(key), valueType, sessionTimeZone));
                    }
                    return formattedMap;
                }
                if (fieldType instanceof MapType && field instanceof MapData) {
                    MapData map = (MapData)field;
                    HashMap<Object, Object> formattedMap = new HashMap<Object, Object>(map.size());
                    Object[] keyArray = (Object[])PrintUtils.formattedTimestamp(map.keyArray(), keyType, sessionTimeZone);
                    Object[] valueArray = (Object[])PrintUtils.formattedTimestamp(map.valueArray(), valueType, sessionTimeZone);
                    for (int i = 0; i < keyArray.length; ++i) {
                        formattedMap.put(keyArray[i], valueArray[i]);
                    }
                    return formattedMap;
                }
                return field;
            }
        }
        return field;
    }

    private static Object formatTimestampField(Object timestampField, LogicalType fieldType, ZoneId sessionTimeZone) {
        switch (fieldType.getTypeRoot()) {
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                int precision = LogicalTypeChecks.getPrecision((LogicalType)fieldType);
                if (timestampField instanceof Timestamp) {
                    return TimestampStringUtils.timestampToString(((Timestamp)timestampField).toLocalDateTime(), precision);
                }
                if (timestampField instanceof LocalDateTime) {
                    return TimestampStringUtils.timestampToString((LocalDateTime)timestampField, precision);
                }
                if (timestampField instanceof TimestampData) {
                    return TimestampStringUtils.timestampToString(((TimestampData)timestampField).toLocalDateTime(), precision);
                }
                return timestampField;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                Instant instant = null;
                if (timestampField instanceof Instant) {
                    instant = (Instant)timestampField;
                } else if (timestampField instanceof Timestamp) {
                    Timestamp timestamp = (Timestamp)timestampField;
                    instant = TimestampData.fromEpochMillis((long)timestamp.getTime(), (int)(timestamp.getNanos() % 1000000)).toInstant();
                } else if (timestampField instanceof TimestampData) {
                    instant = ((TimestampData)timestampField).toInstant();
                } else if (timestampField instanceof Integer) {
                    instant = Instant.ofEpochSecond(((Integer)timestampField).intValue());
                } else if (timestampField instanceof Long) {
                    instant = Instant.ofEpochMilli((Long)timestampField);
                }
                if (instant != null) {
                    return TimestampStringUtils.timestampToString(instant.atZone(sessionTimeZone).toLocalDateTime(), LogicalTypeChecks.getPrecision((LogicalType)fieldType));
                }
                return timestampField;
            }
        }
        return timestampField;
    }

    private static Object formatTimeField(Object timeField) {
        if (timeField.getClass().isAssignableFrom(Integer.TYPE) || timeField instanceof Integer) {
            return TimestampStringUtils.unixTimeToString((Integer)timeField);
        }
        if (timeField.getClass().isAssignableFrom(Long.TYPE) || timeField instanceof Long) {
            return TimestampStringUtils.unixTimeToString(((Long)timeField).intValue());
        }
        if (timeField instanceof Time) {
            return TimestampStringUtils.unixTimeToString(TimestampStringUtils.timeToInternal((Time)timeField));
        }
        if (timeField instanceof LocalTime) {
            return TimestampStringUtils.unixTimeToString(TimestampStringUtils.localTimeToUnixDate((LocalTime)timeField));
        }
        return timeField;
    }
}

