/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.flink;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.zeppelin.flink.FlinkSqlContext;
import org.apache.zeppelin.flink.FlinkVersion;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FlinkShims {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlinkShims.class);
    private static FlinkShims flinkShims;
    protected Properties properties;
    protected FlinkVersion flinkVersion;
    protected FlinkSqlContext flinkSqlContext;

    public FlinkShims(FlinkVersion flinkVersion, Properties properties) {
        this.flinkVersion = flinkVersion;
        this.properties = properties;
    }

    private static FlinkShims loadShims(FlinkVersion flinkVersion, Properties properties) throws Exception {
        Class<?> flinkShimsClass;
        if (flinkVersion.getMajorVersion() == 1 && flinkVersion.getMinorVersion() == 13) {
            LOGGER.info("Initializing shims for Flink 1.13");
            flinkShimsClass = Class.forName("org.apache.zeppelin.flink.Flink113Shims");
        } else if (flinkVersion.getMajorVersion() == 1 && flinkVersion.getMinorVersion() == 14) {
            LOGGER.info("Initializing shims for Flink 1.14");
            flinkShimsClass = Class.forName("org.apache.zeppelin.flink.Flink114Shims");
        } else if (flinkVersion.getMajorVersion() == 1 && flinkVersion.getMinorVersion() == 15) {
            LOGGER.info("Initializing shims for Flink 1.15");
            flinkShimsClass = Class.forName("org.apache.zeppelin.flink.Flink115Shims");
        } else if (flinkVersion.getMajorVersion() == 1 && flinkVersion.getMinorVersion() == 16) {
            LOGGER.info("Initializing shims for Flink 1.16");
            flinkShimsClass = Class.forName("org.apache.zeppelin.flink.Flink116Shims");
        } else if (flinkVersion.getMajorVersion() == 1 && flinkVersion.getMinorVersion() == 17) {
            LOGGER.info("Initializing shims for Flink 1.17");
            flinkShimsClass = Class.forName("org.apache.zeppelin.flink.Flink117Shims");
        } else {
            throw new Exception("Flink version: '" + flinkVersion + "' is not supported yet");
        }
        Constructor<?> c = flinkShimsClass.getConstructor(FlinkVersion.class, Properties.class);
        return (FlinkShims)c.newInstance(flinkVersion, properties);
    }

    public static FlinkShims getInstance(FlinkVersion flinkVersion, Properties properties) throws Exception {
        if (flinkShims == null) {
            flinkShims = FlinkShims.loadShims(flinkVersion, properties);
        }
        return flinkShims;
    }

    public FlinkVersion getFlinkVersion() {
        return this.flinkVersion;
    }

    public abstract Object createFunctionCatalog(Object var1, Object var2, Object var3, List<URL> var4);

    public abstract void initInnerBatchSqlInterpreter(FlinkSqlContext var1);

    public abstract void initInnerStreamSqlInterpreter(FlinkSqlContext var1);

    public abstract void disableSysoutLogging(Object var1, Object var2);

    public abstract Object createStreamExecutionEnvironmentFactory(Object var1);

    public abstract Object createCatalogManager(Object var1);

    public abstract String getPyFlinkPythonPath(Properties var1) throws IOException;

    public abstract Object getCollectStreamTableSink(InetAddress var1, int var2, Object var3);

    public abstract List collectToList(Object var1) throws Exception;

    public abstract boolean rowEquals(Object var1, Object var2);

    public abstract Object fromDataSet(Object var1, Object var2);

    public abstract Object toDataSet(Object var1, Object var2);

    public abstract void registerScalarFunction(Object var1, String var2, Object var3);

    public abstract void registerTableFunction(Object var1, String var2, Object var3);

    public abstract void registerAggregateFunction(Object var1, String var2, Object var3);

    public abstract void registerTableAggregateFunction(Object var1, String var2, Object var3);

    public abstract void registerTableSink(Object var1, String var2, Object var3);

    public abstract void setCatalogManagerSchemaResolver(Object var1, Object var2, Object var3);

    public abstract Object updateEffectiveConfig(Object var1, Object var2, Object var3);

    public void setBatchRuntimeMode(Object tableConfig) {
    }

    public void setOldPlanner(Object tableConfig) {
    }

    public abstract String[] rowToString(Object var1, Object var2, Object var3);

    public abstract boolean isTimeIndicatorType(Object var1);

    public abstract ImmutablePair<Object, Object> createPlannerAndExecutor(ClassLoader var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7);

    public abstract Object createResourceManager(List<URL> var1, Object var2);

    public abstract Object createScalaBlinkStreamTableEnvironment(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6, List<URL> var7, ClassLoader var8);

    public abstract Object createJavaBlinkStreamTableEnvironment(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6, List<URL> var7, ClassLoader var8);

    public abstract Object createBlinkPlannerEnvSettingBuilder();

    public abstract Object createOldPlannerEnvSettingBuilder();

    public abstract InterpreterResult runSqlList(String var1, InterpreterContext var2, boolean var3);
}

