/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.flink;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.client.cli.CliFrontend;
import org.apache.flink.client.cli.CustomCommandLine;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironmentFactory;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.bridge.scala.internal.StreamTableEnvironmentImpl;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.ExecutorFactory;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.PlannerFactoryUtil;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableAggregateFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.FlinkException;
import org.apache.zeppelin.flink.Flink115SqlInterpreter;
import org.apache.zeppelin.flink.FlinkShims;
import org.apache.zeppelin.flink.FlinkSqlContext;
import org.apache.zeppelin.flink.FlinkVersion;
import org.apache.zeppelin.flink.PrintUtils;
import org.apache.zeppelin.flink.shims115.CollectStreamTableSink;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Flink115Shims
extends FlinkShims {
    private static final Logger LOGGER = LoggerFactory.getLogger(Flink115Shims.class);
    private Flink115SqlInterpreter batchSqlInterpreter;
    private Flink115SqlInterpreter streamSqlInterpreter;

    public Flink115Shims(FlinkVersion flinkVersion, Properties properties) {
        super(flinkVersion, properties);
    }

    @Override
    public void initInnerBatchSqlInterpreter(FlinkSqlContext flinkSqlContext) {
        this.batchSqlInterpreter = new Flink115SqlInterpreter(flinkSqlContext, true);
    }

    @Override
    public void initInnerStreamSqlInterpreter(FlinkSqlContext flinkSqlContext) {
        this.streamSqlInterpreter = new Flink115SqlInterpreter(flinkSqlContext, false);
    }

    @Override
    public Object createResourceManager(List<URL> jars, Object tableConfig) {
        return null;
    }

    @Override
    public Object createFunctionCatalog(Object tableConfig, Object catalogManager, Object moduleManager, List<URL> jars) {
        return new FunctionCatalog((ReadableConfig)((TableConfig)tableConfig), (CatalogManager)catalogManager, (ModuleManager)moduleManager);
    }

    @Override
    public void disableSysoutLogging(Object batchConfig, Object streamConfig) {
    }

    @Override
    public Object createScalaBlinkStreamTableEnvironment(Object environmentSettingsObj, Object senvObj, Object tableConfigObj, Object moduleManagerObj, Object functionCatalogObj, Object catalogManagerObj, List<URL> jars, ClassLoader classLoader) {
        EnvironmentSettings environmentSettings = (EnvironmentSettings)environmentSettingsObj;
        StreamExecutionEnvironment senv = (StreamExecutionEnvironment)senvObj;
        TableConfig tableConfig = (TableConfig)tableConfigObj;
        ModuleManager moduleManager = (ModuleManager)moduleManagerObj;
        FunctionCatalog functionCatalog = (FunctionCatalog)functionCatalogObj;
        CatalogManager catalogManager = (CatalogManager)catalogManagerObj;
        ImmutablePair<Object, Object> pair = this.createPlannerAndExecutor(classLoader, environmentSettings, senv, tableConfig, moduleManager, functionCatalog, catalogManager);
        Planner planner = (Planner)pair.left;
        Executor executor = (Executor)pair.right;
        return new StreamTableEnvironmentImpl(catalogManager, moduleManager, functionCatalog, tableConfig, new org.apache.flink.streaming.api.scala.StreamExecutionEnvironment(senv), planner, executor, environmentSettings.isStreamingMode(), classLoader);
    }

    @Override
    public Object createJavaBlinkStreamTableEnvironment(Object environmentSettingsObj, Object senvObj, Object tableConfigObj, Object moduleManagerObj, Object functionCatalogObj, Object catalogManagerObj, List<URL> jars, ClassLoader classLoader) {
        EnvironmentSettings environmentSettings = (EnvironmentSettings)environmentSettingsObj;
        StreamExecutionEnvironment senv = (StreamExecutionEnvironment)senvObj;
        TableConfig tableConfig = (TableConfig)tableConfigObj;
        ModuleManager moduleManager = (ModuleManager)moduleManagerObj;
        FunctionCatalog functionCatalog = (FunctionCatalog)functionCatalogObj;
        CatalogManager catalogManager = (CatalogManager)catalogManagerObj;
        ImmutablePair<Object, Object> pair = this.createPlannerAndExecutor(classLoader, environmentSettings, senv, tableConfig, moduleManager, functionCatalog, catalogManager);
        Planner planner = (Planner)pair.left;
        Executor executor = (Executor)pair.right;
        return new org.apache.flink.table.api.bridge.java.internal.StreamTableEnvironmentImpl(catalogManager, moduleManager, functionCatalog, tableConfig, senv, planner, executor, environmentSettings.isStreamingMode(), classLoader);
    }

    @Override
    public Object createStreamExecutionEnvironmentFactory(final Object streamExecutionEnvironment) {
        return new StreamExecutionEnvironmentFactory(){

            public StreamExecutionEnvironment createExecutionEnvironment(Configuration configuration) {
                return (StreamExecutionEnvironment)streamExecutionEnvironment;
            }
        };
    }

    @Override
    public Object createCatalogManager(Object config) {
        return CatalogManager.newBuilder().classLoader(Thread.currentThread().getContextClassLoader()).config((ReadableConfig)config).defaultCatalog("default_catalog", (Catalog)new GenericInMemoryCatalog("default_catalog", "default_database")).build();
    }

    @Override
    public String getPyFlinkPythonPath(Properties properties) throws IOException {
        String mode = properties.getProperty("flink.execution.mode");
        if ("yarn-application".equalsIgnoreCase(mode)) {
            String flinkHome = new File(".").getAbsolutePath();
            return this.getPyFlinkPythonPath(new File(flinkHome + "/lib/python"));
        }
        String flinkHome = System.getenv("FLINK_HOME");
        if (StringUtils.isNotBlank(flinkHome)) {
            return this.getPyFlinkPythonPath(new File(flinkHome + "/opt/python"));
        }
        throw new IOException("No FLINK_HOME is specified");
    }

    private String getPyFlinkPythonPath(File pyFlinkFolder) throws IOException {
        LOGGER.info("Getting pyflink lib from {}", (Object)pyFlinkFolder);
        if (!pyFlinkFolder.exists() || !pyFlinkFolder.isDirectory()) {
            throw new IOException(String.format("PyFlink folder %s does not exist or is not a folder", pyFlinkFolder.getAbsolutePath()));
        }
        List<File> depFiles = Arrays.asList(pyFlinkFolder.listFiles());
        StringBuilder builder = new StringBuilder();
        for (File file : depFiles) {
            LOGGER.info("Adding extracted file {} to PYTHONPATH", (Object)file.getAbsolutePath());
            builder.append(file.getAbsolutePath() + ":");
        }
        return builder.toString();
    }

    @Override
    public Object getCollectStreamTableSink(InetAddress targetAddress, int targetPort, Object serializer) {
        return new CollectStreamTableSink(targetAddress, targetPort, (TypeSerializer<Tuple2<Boolean, Row>>)((TypeSerializer)serializer));
    }

    @Override
    public List collectToList(Object table) throws Exception {
        return Lists.newArrayList((Iterator)((Table)table).execute().collect());
    }

    @Override
    public boolean rowEquals(Object row1, Object row2) {
        Row r1 = (Row)row1;
        Row r2 = (Row)row2;
        r1.setKind(RowKind.INSERT);
        r2.setKind(RowKind.INSERT);
        return r1.equals((Object)r2);
    }

    @Override
    public Object fromDataSet(Object btenv, Object ds) {
        throw new RuntimeException("Conversion from DataSet is not supported in Flink 1.15");
    }

    @Override
    public Object toDataSet(Object btenv, Object table) {
        throw new RuntimeException("Conversion to DataSet is not supported in Flink 1.15");
    }

    @Override
    public void registerTableSink(Object stenv, String tableName, Object collectTableSink) {
        ((TableEnvironmentInternal)stenv).registerTableSinkInternal(tableName, (TableSink)collectTableSink);
    }

    @Override
    public void registerScalarFunction(Object btenv, String name, Object scalarFunction) {
        ((org.apache.flink.table.api.bridge.java.internal.StreamTableEnvironmentImpl)btenv).createTemporarySystemFunction(name, (UserDefinedFunction)((ScalarFunction)scalarFunction));
    }

    @Override
    public void registerTableFunction(Object btenv, String name, Object tableFunction) {
        ((org.apache.flink.table.api.bridge.java.internal.StreamTableEnvironmentImpl)btenv).registerFunction(name, (TableFunction)tableFunction);
    }

    @Override
    public void registerAggregateFunction(Object btenv, String name, Object aggregateFunction) {
        ((org.apache.flink.table.api.bridge.java.internal.StreamTableEnvironmentImpl)btenv).registerFunction(name, (AggregateFunction)aggregateFunction);
    }

    @Override
    public void registerTableAggregateFunction(Object btenv, String name, Object tableAggregateFunction) {
        ((org.apache.flink.table.api.bridge.java.internal.StreamTableEnvironmentImpl)btenv).registerFunction(name, (TableAggregateFunction)tableAggregateFunction);
    }

    @Override
    public void setCatalogManagerSchemaResolver(Object catalogManager, Object parserObject, Object environmentSetting) {
    }

    @Override
    public Object updateEffectiveConfig(Object cliFrontend, Object commandLine, Object effectiveConfig) {
        CustomCommandLine customCommandLine = ((CliFrontend)cliFrontend).validateAndGetActiveCommandLine((CommandLine)commandLine);
        try {
            ((Configuration)effectiveConfig).addAll(customCommandLine.toConfiguration((CommandLine)commandLine));
            return effectiveConfig;
        }
        catch (FlinkException e) {
            throw new RuntimeException("Fail to call addAll", e);
        }
    }

    @Override
    public void setBatchRuntimeMode(Object tableConfig) {
        ((TableConfig)tableConfig).getConfiguration().set(ExecutionOptions.RUNTIME_MODE, (Object)RuntimeExecutionMode.BATCH);
    }

    @Override
    public void setOldPlanner(Object tableConfig) {
    }

    @Override
    public String[] rowToString(Object row, Object table, Object tableConfig) {
        String zone = (String)((TableConfig)tableConfig).getConfiguration().get(TableConfigOptions.LOCAL_TIME_ZONE);
        ZoneId zoneId = ((String)TableConfigOptions.LOCAL_TIME_ZONE.defaultValue()).equals(zone) ? ZoneId.systemDefault() : ZoneId.of(zone);
        ResolvedSchema resolvedSchema = ((Table)table).getResolvedSchema();
        return PrintUtils.rowToString((Row)row, resolvedSchema, zoneId);
    }

    @Override
    public boolean isTimeIndicatorType(Object type) {
        return FlinkTypeFactory.isTimeIndicatorType((TypeInformation)((TypeInformation)type));
    }

    private Object lookupExecutor(ClassLoader classLoader, Object settings, Object sEnv) {
        try {
            ExecutorFactory executorFactory = (ExecutorFactory)FactoryUtil.discoverFactory((ClassLoader)classLoader, ExecutorFactory.class, (String)"default");
            Method createMethod = executorFactory.getClass().getMethod("create", StreamExecutionEnvironment.class);
            return createMethod.invoke((Object)executorFactory, sEnv);
        }
        catch (Exception e) {
            throw new TableException("Could not instantiate the executor. Make sure a planner module is on the classpath", (Throwable)e);
        }
    }

    @Override
    public ImmutablePair<Object, Object> createPlannerAndExecutor(ClassLoader classLoader, Object environmentSettings, Object sEnv, Object tableConfig, Object moduleManager, Object functionCatalog, Object catalogManager) {
        EnvironmentSettings settings = (EnvironmentSettings)environmentSettings;
        Executor executor = (Executor)this.lookupExecutor(classLoader, environmentSettings, sEnv);
        Planner planner = PlannerFactoryUtil.createPlanner((Executor)executor, (TableConfig)((TableConfig)tableConfig), (ModuleManager)((ModuleManager)moduleManager), (CatalogManager)((CatalogManager)catalogManager), (FunctionCatalog)((FunctionCatalog)functionCatalog));
        return ImmutablePair.of(planner, executor);
    }

    @Override
    public Object createBlinkPlannerEnvSettingBuilder() {
        return EnvironmentSettings.newInstance();
    }

    @Override
    public Object createOldPlannerEnvSettingBuilder() {
        return EnvironmentSettings.newInstance();
    }

    @Override
    public InterpreterResult runSqlList(String st, InterpreterContext context, boolean isBatch) {
        if (isBatch) {
            return this.batchSqlInterpreter.runSqlList(st, context);
        }
        return this.streamSqlInterpreter.runSqlList(st, context);
    }
}

