/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.server;

import com.codahale.metrics.servlets.HealthCheckServlet;
import com.codahale.metrics.servlets.PingServlet;
import com.google.gson.Gson;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.jetty.InstrumentedQueuedThreadPool;
import io.micrometer.core.instrument.binder.jetty.JettyConnectionMetrics;
import io.micrometer.core.instrument.binder.jetty.JettySslHandshakeMetrics;
import io.micrometer.core.instrument.binder.jetty.TimedHandler;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import io.micrometer.jmx.JmxConfig;
import io.micrometer.jmx.JmxMeterRegistry;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Singleton;
import javax.management.remote.JMXServiceURL;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.web.env.EnvironmentLoaderListener;
import org.apache.shiro.web.servlet.ShiroFilter;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.display.AngularObjectRegistryListener;
import org.apache.zeppelin.healthcheck.HealthChecks;
import org.apache.zeppelin.helium.ApplicationEventListener;
import org.apache.zeppelin.helium.Helium;
import org.apache.zeppelin.helium.HeliumApplicationFactory;
import org.apache.zeppelin.helium.HeliumBundleFactory;
import org.apache.zeppelin.interpreter.InterpreterFactory;
import org.apache.zeppelin.interpreter.InterpreterSettingManager;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcessListener;
import org.apache.zeppelin.metric.JVMInfoBinder;
import org.apache.zeppelin.metric.PrometheusServlet;
import org.apache.zeppelin.notebook.AuthorizationService;
import org.apache.zeppelin.notebook.GsonNoteParser;
import org.apache.zeppelin.notebook.NoteEventListener;
import org.apache.zeppelin.notebook.NoteManager;
import org.apache.zeppelin.notebook.NoteParser;
import org.apache.zeppelin.notebook.Notebook;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.notebook.repo.NotebookRepo;
import org.apache.zeppelin.notebook.repo.NotebookRepoSync;
import org.apache.zeppelin.notebook.scheduler.NoSchedulerService;
import org.apache.zeppelin.notebook.scheduler.QuartzSchedulerService;
import org.apache.zeppelin.notebook.scheduler.SchedulerService;
import org.apache.zeppelin.plugin.PluginManager;
import org.apache.zeppelin.search.LuceneSearch;
import org.apache.zeppelin.search.NoSearchService;
import org.apache.zeppelin.search.SearchService;
import org.apache.zeppelin.server.CorsFilter;
import org.apache.zeppelin.server.ErrorData;
import org.apache.zeppelin.server.ImmediateErrorHandlerImpl;
import org.apache.zeppelin.server.IndexHtmlServlet;
import org.apache.zeppelin.server.RestApiApplication;
import org.apache.zeppelin.service.AdminService;
import org.apache.zeppelin.service.AuthenticationService;
import org.apache.zeppelin.service.ConfigurationService;
import org.apache.zeppelin.service.InterpreterService;
import org.apache.zeppelin.service.JobManagerService;
import org.apache.zeppelin.service.NoAuthenticationService;
import org.apache.zeppelin.service.NotebookService;
import org.apache.zeppelin.service.ServiceCallback;
import org.apache.zeppelin.service.ServiceContext;
import org.apache.zeppelin.service.ShiroAuthenticationService;
import org.apache.zeppelin.socket.ConnectionManager;
import org.apache.zeppelin.socket.NotebookServer;
import org.apache.zeppelin.socket.SessionConfigurator;
import org.apache.zeppelin.storage.ConfigStorage;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.apache.zeppelin.user.Credentials;
import org.apache.zeppelin.utils.PEMImporter;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.jmx.ConnectorServer;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeppelinServer
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeppelinServer.class);
    private static final String NON_DEFAULT_NEW_UI_WEB_APP_CONTEXT_PATH = "/new";
    private static final String NON_DEFAULT_CLASSIC_UI_WEB_APP_CONTEXT_PATH = "/classic";
    public static final String DEFAULT_SERVICE_LOCATOR_NAME = "shared-locator";
    private final AtomicBoolean duringShutdown = new AtomicBoolean(false);
    private final ZeppelinConfiguration zConf;
    private final Optional<PrometheusMeterRegistry> promMetricRegistry;
    private final Server jettyWebServer;
    private final ServiceLocator sharedServiceLocator;
    private final ConfigStorage storage;

    public ZeppelinServer(ZeppelinConfiguration zConf) throws IOException {
        this(zConf, DEFAULT_SERVICE_LOCATOR_NAME);
    }

    public ZeppelinServer(ZeppelinConfiguration zConf, String serviceLocatorName) throws IOException {
        LOGGER.info("Instantiated ZeppelinServer");
        this.zConf = zConf;
        this.promMetricRegistry = zConf.isPrometheusMetricEnabled() ? Optional.of(new PrometheusMeterRegistry(PrometheusConfig.DEFAULT)) : Optional.empty();
        this.jettyWebServer = this.setupJettyServer();
        this.sharedServiceLocator = ServiceLocatorFactory.getInstance().create(serviceLocatorName);
        this.storage = ConfigStorage.createConfigStorage((ZeppelinConfiguration)zConf);
    }

    public void startZeppelin() {
        String newUiWebAppContextPath;
        String classicUiWebAppContextPath;
        this.initMetrics();
        TimedHandler timedHandler = new TimedHandler((MeterRegistry)Metrics.globalRegistry, (Iterable)Tags.empty());
        this.jettyWebServer.setHandler((Handler)timedHandler);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        timedHandler.setHandler((Handler)contexts);
        ServiceLocatorUtilities.enableImmediateScope((ServiceLocator)this.sharedServiceLocator);
        ServiceLocatorUtilities.addClasses((ServiceLocator)this.sharedServiceLocator, (Class[])new Class[]{ImmediateErrorHandlerImpl.class});
        ImmediateErrorHandlerImpl handler = (ImmediateErrorHandlerImpl)this.sharedServiceLocator.getService(ImmediateErrorHandlerImpl.class, new Annotation[0]);
        ServiceLocatorUtilities.bind((ServiceLocator)this.sharedServiceLocator, (Binder[])new Binder[]{new AbstractBinder(){

            protected void configure() {
                this.bind(ZeppelinServer.this.storage).to(ConfigStorage.class);
                this.bindAsContract(PluginManager.class).in(Singleton.class);
                this.bind(GsonNoteParser.class).to(NoteParser.class).in(Singleton.class);
                this.bindAsContract(InterpreterFactory.class).in(Singleton.class);
                this.bindAsContract(NotebookRepoSync.class).to(NotebookRepo.class).in(Singleton.class);
                this.bindAsContract(Helium.class).in(Singleton.class);
                this.bind(ZeppelinServer.this.zConf).to(ZeppelinConfiguration.class);
                this.bindAsContract(InterpreterSettingManager.class).in(Singleton.class);
                this.bindAsContract(InterpreterService.class).in(Singleton.class);
                this.bindAsContract(Credentials.class).in(Singleton.class);
                this.bindAsContract(AdminService.class).in(Singleton.class);
                this.bindAsContract(AuthorizationService.class).in(Singleton.class);
                this.bindAsContract(ConnectionManager.class).in(Singleton.class);
                this.bindAsContract(NoteManager.class).in(Singleton.class);
                if (!StringUtils.isBlank((CharSequence)ZeppelinServer.this.zConf.getShiroPath())) {
                    this.bind(ShiroAuthenticationService.class).to(AuthenticationService.class).in(Singleton.class);
                } else {
                    this.bind(NoAuthenticationService.class).to(AuthenticationService.class).in(Singleton.class);
                }
                this.bindAsContract(HeliumBundleFactory.class).in(Singleton.class);
                this.bindAsContract(HeliumApplicationFactory.class).in(Singleton.class);
                this.bindAsContract(ConfigurationService.class).in(Singleton.class);
                this.bindAsContract(NotebookService.class).in(Singleton.class);
                this.bindAsContract(JobManagerService.class).in(Singleton.class);
                this.bindAsContract(Notebook.class).in(Singleton.class);
                this.bindAsContract(NotebookServer.class).to(AngularObjectRegistryListener.class).to(RemoteInterpreterProcessListener.class).to(ApplicationEventListener.class).to(NoteEventListener.class).to(WebSocketServlet.class).in(Singleton.class);
                if (ZeppelinServer.this.zConf.isZeppelinNotebookCronEnable()) {
                    this.bind(QuartzSchedulerService.class).to(SchedulerService.class).in(Singleton.class);
                } else {
                    this.bind(NoSchedulerService.class).to(SchedulerService.class).in(Singleton.class);
                }
                if (ZeppelinServer.this.zConf.getBoolean(ZeppelinConfiguration.ConfVars.ZEPPELIN_SEARCH_ENABLE)) {
                    this.bind(LuceneSearch.class).to(SearchService.class).in(Singleton.class);
                } else {
                    this.bind(NoSearchService.class).to(SearchService.class).in(Singleton.class);
                }
            }
        }});
        if (ZeppelinServer.isNewUiDefault(this.zConf)) {
            classicUiWebAppContextPath = NON_DEFAULT_CLASSIC_UI_WEB_APP_CONTEXT_PATH;
            newUiWebAppContextPath = this.zConf.getServerContextPath();
        } else {
            classicUiWebAppContextPath = this.zConf.getServerContextPath();
            newUiWebAppContextPath = NON_DEFAULT_NEW_UI_WEB_APP_CONTEXT_PATH;
        }
        WebAppContext newUiWebApp = ZeppelinServer.setupWebAppContext(contexts, this.zConf, this.zConf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_ANGULAR_WAR), newUiWebAppContextPath);
        WebAppContext classicUiWebApp = ZeppelinServer.setupWebAppContext(contexts, this.zConf, this.zConf.getString(ZeppelinConfiguration.ConfVars.ZEPPELIN_WAR), classicUiWebAppContextPath);
        this.initWebApp(newUiWebApp);
        this.initWebApp(classicUiWebApp);
        NotebookRepo repo = (NotebookRepo)ServiceLocatorUtilities.getService((ServiceLocator)this.sharedServiceLocator, (String)NotebookRepo.class.getName());
        NoteParser noteParser = (NoteParser)ServiceLocatorUtilities.getService((ServiceLocator)this.sharedServiceLocator, (String)NoteParser.class.getName());
        try {
            repo.init(this.zConf, noteParser);
        }
        catch (IOException e) {
            LOGGER.error("Failed to init NotebookRepo", (Throwable)e);
        }
        this.initJMX();
        this.runNoteOnStart(this.sharedServiceLocator);
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
        Notebook notebook = (Notebook)ServiceLocatorUtilities.getService((ServiceLocator)this.sharedServiceLocator, (String)Notebook.class.getName());
        ServiceLocatorUtilities.getService((ServiceLocator)this.sharedServiceLocator, (String)SearchService.class.getName());
        ServiceLocatorUtilities.getService((ServiceLocator)this.sharedServiceLocator, (String)SchedulerService.class.getName());
        notebook.initNotebook();
        notebook.recoveryIfNecessary();
        LOGGER.info("Starting zeppelin server");
        try {
            this.jettyWebServer.start();
            if (this.zConf.getJettyName() != null) {
                HttpGenerator.setJettyVersion((String)this.zConf.getJettyName());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while running jettyServer", (Throwable)e);
            System.exit(-1);
        }
        LOGGER.info("Done, zeppelin server started");
        try {
            List<ErrorData> errorDatas = handler.waitForAtLeastOneConstructionError(5000L);
            for (ErrorData errorData : errorDatas) {
                LOGGER.error("Error in Construction", errorData.getThrowable());
            }
            if (!errorDatas.isEmpty()) {
                LOGGER.error("{} error(s) while starting - Termination", (Object)errorDatas.size());
                System.exit(-1);
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Interrupt while waiting for construction errors - init shutdown", (Throwable)e);
            this.shutdown();
            Thread.currentThread().interrupt();
        }
        if (this.jettyWebServer.isStopped() || this.jettyWebServer.isStopping()) {
            LOGGER.debug("jetty server is stopped {} - is stopping {}", (Object)this.jettyWebServer.isStopped(), (Object)this.jettyWebServer.isStopping());
        } else {
            try {
                this.jettyWebServer.join();
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupt while waiting for jetty threads - init shutdown", (Throwable)e);
                this.shutdown();
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        ZeppelinConfiguration zConf = ZeppelinConfiguration.load();
        zConf.printShortInfo();
        try (ZeppelinServer server = new ZeppelinServer(zConf);){
            server.startZeppelin();
        }
    }

    private void initJMX() {
        if (this.zConf.isJMXEnabled()) {
            int port = this.zConf.getJMXPort();
            MBeanContainer mbeanContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
            this.jettyWebServer.addBean((Object)mbeanContainer);
            try {
                JMXServiceURL jmxURL = new JMXServiceURL(String.format("service:jmx:rmi://0.0.0.0:%d/jndi/rmi://0.0.0.0:%d/jmxrmi", port, port));
                ConnectorServer jmxServer = new ConnectorServer(jmxURL, "org.eclipse.jetty.jmx:name=rmiconnectorserver");
                this.jettyWebServer.addBean((Object)jmxServer);
                LOGGER.info("JMX Enabled with port: {}", (Object)port);
            }
            catch (MalformedURLException e) {
                LOGGER.error("Invalid JMXServiceURL - JMX Disabled", (Throwable)e);
            }
        }
    }

    private void initMetrics() {
        if (this.zConf.isJMXEnabled()) {
            Metrics.addRegistry((MeterRegistry)new JmxMeterRegistry(JmxConfig.DEFAULT, Clock.SYSTEM));
        }
        if (this.promMetricRegistry.isPresent()) {
            Metrics.addRegistry((MeterRegistry)((MeterRegistry)this.promMetricRegistry.get()));
        }
        new ClassLoaderMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new JvmMemoryMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new JvmThreadMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new FileDescriptorMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new ProcessorMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new UptimeMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new JVMInfoBinder().bindTo((MeterRegistry)Metrics.globalRegistry);
    }

    public void shutdown(int exitCode) {
        if (!this.duringShutdown.getAndSet(true)) {
            LOGGER.info("Shutting down Zeppelin Server ... - ExitCode {}", (Object)exitCode);
            try {
                if (this.jettyWebServer != null) {
                    this.jettyWebServer.stop();
                }
                if (this.sharedServiceLocator != null) {
                    if (!this.zConf.isRecoveryEnabled()) {
                        ((InterpreterSettingManager)this.sharedServiceLocator.getService(InterpreterSettingManager.class, new Annotation[0])).close();
                    }
                    ((Notebook)this.sharedServiceLocator.getService(Notebook.class, new Annotation[0])).close();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error while stopping servlet container", (Throwable)e);
            }
            LOGGER.info("Bye");
            if (exitCode != 0) {
                System.exit(exitCode);
            }
        }
    }

    public void shutdown() {
        this.shutdown(0);
    }

    private Server setupJettyServer() {
        InstrumentedQueuedThreadPool threadPool = new InstrumentedQueuedThreadPool((MeterRegistry)Metrics.globalRegistry, (Iterable)Tags.empty(), this.zConf.getInt(ZeppelinConfiguration.ConfVars.ZEPPELIN_SERVER_JETTY_THREAD_POOL_MAX), this.zConf.getInt(ZeppelinConfiguration.ConfVars.ZEPPELIN_SERVER_JETTY_THREAD_POOL_MIN), this.zConf.getInt(ZeppelinConfiguration.ConfVars.ZEPPELIN_SERVER_JETTY_THREAD_POOL_TIMEOUT));
        Server server = new Server((ThreadPool)threadPool);
        this.initServerConnector(server);
        return server;
    }

    private void initServerConnector(Server server) {
        ServerConnector connector;
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
        httpConfig.setSendServerVersion(this.zConf.sendJettyName());
        httpConfig.setRequestHeaderSize(this.zConf.getJettyRequestHeaderSize().intValue());
        if (this.zConf.useSsl()) {
            LOGGER.debug("Enabling SSL for Zeppelin Server on port {}", (Object)this.zConf.getServerSslPort());
            httpConfig.setSecureScheme(HttpScheme.HTTPS.asString());
            httpConfig.setSecurePort(this.zConf.getServerSslPort());
            HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
            httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(ZeppelinServer.getSslContextFactory(this.zConf), HttpVersion.HTTP_1_1.asString());
            HttpConnectionFactory httpsConnectionFactory = new HttpConnectionFactory(httpsConfig);
            connector = new ServerConnector(server, new ConnectionFactory[]{sslConnectionFactory, httpsConnectionFactory});
            connector.setPort(this.zConf.getServerSslPort());
            connector.addBean((Object)new JettySslHandshakeMetrics((MeterRegistry)Metrics.globalRegistry, (Iterable)Tags.empty()));
        } else {
            HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfig);
            connector = new ServerConnector(server, new ConnectionFactory[]{httpConnectionFactory});
            connector.setPort(this.zConf.getServerPort());
        }
        int timeout = 30000;
        connector.setIdleTimeout((long)timeout);
        connector.setHost(this.zConf.getServerAddress());
        connector.addBean((Object)new JettyConnectionMetrics((MeterRegistry)Metrics.globalRegistry, (Iterable)Tags.empty()));
        server.addConnector((Connector)connector);
    }

    private void runNoteOnStart(ServiceLocator sharedServiceLocator) {
        String noteIdToRun = this.zConf.getNotebookRunId();
        if (!StringUtils.isEmpty((CharSequence)noteIdToRun)) {
            ServiceContext serviceContext;
            LOGGER.info("Running note {} on start", (Object)noteIdToRun);
            NotebookService notebookService = (NotebookService)ServiceLocatorUtilities.getService((ServiceLocator)sharedServiceLocator, (String)NotebookService.class.getName());
            String base64EncodedJsonSerializedServiceContext = this.zConf.getNotebookRunServiceContext();
            if (StringUtils.isEmpty((CharSequence)base64EncodedJsonSerializedServiceContext)) {
                LOGGER.info("No service context provided. use ANONYMOUS");
                serviceContext = new ServiceContext(AuthenticationInfo.ANONYMOUS, new HashSet<String>());
            } else {
                serviceContext = (ServiceContext)new Gson().fromJson(new String(Base64.getDecoder().decode(base64EncodedJsonSerializedServiceContext)), ServiceContext.class);
            }
            try {
                boolean success = notebookService.runAllParagraphs(noteIdToRun, null, serviceContext, new ServiceCallback<Paragraph>(){

                    @Override
                    public void onStart(String message, ServiceContext context) throws IOException {
                    }

                    @Override
                    public void onSuccess(Paragraph result, ServiceContext context) throws IOException {
                    }

                    @Override
                    public void onFailure(Exception ex, ServiceContext context) throws IOException {
                    }
                });
                if (this.zConf.getNotebookRunAutoShutdown()) {
                    this.shutdown(success ? 0 : 1);
                }
            }
            catch (IOException e) {
                LOGGER.error("Error during Paragraph Execution", (Throwable)e);
            }
        }
    }

    private void setupNotebookServer(WebAppContext webapp) {
        String maxTextMessageSize = this.zConf.getWebsocketMaxTextMessageSize();
        WebSocketServerContainerInitializer.configure((ServletContextHandler)webapp, (servletContext, wsContainer) -> {
            wsContainer.setDefaultMaxTextMessageBufferSize(Integer.parseInt(maxTextMessageSize));
            wsContainer.addEndpoint(ServerEndpointConfig.Builder.create(NotebookServer.class, (String)"/ws").configurator((ServerEndpointConfig.Configurator)new SessionConfigurator(this.sharedServiceLocator)).build());
        });
    }

    private static SslContextFactory getSslContextFactory(ZeppelinConfiguration zConf) {
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{zConf.getPemKeyFile(), zConf.getPemCertFile()})) {
            ZeppelinServer.setupKeystoreWithPemFiles(sslContextFactory, zConf);
        } else {
            sslContextFactory.setKeyStorePath(zConf.getKeyStorePath());
            sslContextFactory.setKeyStoreType(zConf.getKeyStoreType());
            sslContextFactory.setKeyStorePassword(zConf.getKeyStorePassword());
            sslContextFactory.setKeyManagerPassword(zConf.getKeyManagerPassword());
        }
        if (zConf.useClientAuth()) {
            if (StringUtils.isNotBlank((CharSequence)zConf.getPemCAFile())) {
                ZeppelinServer.setupTruststoreWithPemFiles(sslContextFactory, zConf);
            } else {
                sslContextFactory.setNeedClientAuth(zConf.useClientAuth());
                sslContextFactory.setTrustStorePath(zConf.getTrustStorePath());
                sslContextFactory.setTrustStoreType(zConf.getTrustStoreType());
                sslContextFactory.setTrustStorePassword(zConf.getTrustStorePassword());
            }
        }
        return sslContextFactory;
    }

    private static void setupKeystoreWithPemFiles(SslContextFactory.Server sslContextFactory, ZeppelinConfiguration zConf) {
        File pemKey = new File(zConf.getPemKeyFile());
        File pemCert = new File(zConf.getPemCertFile());
        boolean isPemKeyFileReadable = Files.isReadable(pemKey.toPath());
        boolean isPemCertFileReadable = Files.isReadable(pemCert.toPath());
        if (!isPemKeyFileReadable) {
            LOGGER.warn("PEM key file {} is not readable", (Object)pemKey);
        }
        if (!isPemCertFileReadable) {
            LOGGER.warn("PEM cert file {} is not readable", (Object)pemCert);
        }
        if (isPemKeyFileReadable && isPemCertFileReadable) {
            try {
                String password = zConf.getPemKeyPassword();
                sslContextFactory.setKeyStore(PEMImporter.loadKeyStore(pemCert, pemKey, password));
                sslContextFactory.setKeyStoreType("JKS");
                sslContextFactory.setKeyStorePassword(password);
            }
            catch (IOException | GeneralSecurityException e) {
                LOGGER.error("Failed to initialize KeyStore from PEM files", (Throwable)e);
            }
        } else {
            LOGGER.error("Failed to read PEM files");
        }
    }

    private static void setupTruststoreWithPemFiles(SslContextFactory.Server sslContextFactory, ZeppelinConfiguration zConf) {
        File pemCa = new File(zConf.getPemCAFile());
        if (Files.isReadable(pemCa.toPath())) {
            try {
                sslContextFactory.setTrustStore(PEMImporter.loadTrustStore(pemCa));
                sslContextFactory.setTrustStoreType("JKS");
                sslContextFactory.setTrustStorePassword("");
                sslContextFactory.setNeedClientAuth(zConf.useClientAuth());
            }
            catch (IOException | GeneralSecurityException e) {
                LOGGER.error("Failed to initialize TrustStore from PEM CA file", (Throwable)e);
            }
        } else {
            LOGGER.error("PEM CA file {} is not readable", (Object)pemCa);
        }
    }

    private void setupRestApiContextHandler(WebAppContext webapp) {
        ServletHolder servletHolder = new ServletHolder((Servlet)new ServletContainer());
        servletHolder.setInitParameter("javax.ws.rs.Application", RestApiApplication.class.getName());
        servletHolder.setName("rest");
        webapp.addServlet(servletHolder, "/api/*");
        String shiroIniPath = this.zConf.getShiroPath();
        if (!StringUtils.isBlank((CharSequence)shiroIniPath)) {
            webapp.setInitParameter("shiroConfigLocations", new File(shiroIniPath).toURI().toString());
            webapp.addFilter(ShiroFilter.class, "/api/*", EnumSet.allOf(DispatcherType.class)).setInitParameter("staticSecurityManagerEnabled", "true");
            webapp.addEventListener((EventListener)new EnvironmentLoaderListener());
        }
    }

    private void setupPrometheusContextHandler(WebAppContext webapp) {
        if (this.promMetricRegistry.isPresent()) {
            webapp.addServlet(new ServletHolder((Servlet)new PrometheusServlet(this.promMetricRegistry.get())), "/metrics");
        }
    }

    private static void setupHealthCheckContextHandler(WebAppContext webapp) {
        webapp.addServlet(new ServletHolder((Servlet)new HealthCheckServlet(HealthChecks.getHealthCheckReadinessRegistry())), "/health/readiness");
        webapp.addServlet(new ServletHolder((Servlet)new HealthCheckServlet(HealthChecks.getHealthCheckLivenessRegistry())), "/health/liveness");
        webapp.addServlet(new ServletHolder((Servlet)new PingServlet()), "/ping");
    }

    private static WebAppContext setupWebAppContext(ContextHandlerCollection contexts, ZeppelinConfiguration zConf, String warPath, String contextPath) {
        WebAppContext webApp = new WebAppContext();
        webApp.setContextPath(contextPath);
        LOGGER.info("warPath is: {}", (Object)warPath);
        File warFile = new File(warPath);
        if (warFile.isDirectory()) {
            webApp.setResourceBase(warFile.getPath());
        } else {
            webApp.setWar(warFile.getAbsolutePath());
            webApp.setExtractWAR(false);
            File warTempDirectory = new File(zConf.getAbsoluteDir(ZeppelinConfiguration.ConfVars.ZEPPELIN_WAR_TEMPDIR) + contextPath);
            warTempDirectory.mkdir();
            LOGGER.info("ZeppelinServer Webapp path: {}", (Object)warTempDirectory.getPath());
            webApp.setTempDirectory(warTempDirectory);
        }
        webApp.addServlet(new ServletHolder((Servlet)new IndexHtmlServlet(zConf, contextPath)), "/index.html");
        contexts.addHandler((Handler)webApp);
        webApp.addFilter(new FilterHolder((Filter)new CorsFilter(zConf)), "/*", EnumSet.allOf(DispatcherType.class));
        webApp.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", Boolean.toString(zConf.getBoolean(ZeppelinConfiguration.ConfVars.ZEPPELIN_SERVER_DEFAULT_DIR_ALLOWED)));
        return webApp;
    }

    private void initWebApp(WebAppContext webApp) {
        webApp.addEventListener((EventListener)new ServletContextListener(){

            public void contextInitialized(ServletContextEvent servletContextEvent) {
                servletContextEvent.getServletContext().setAttribute("jersey.config.servlet.context.serviceLocator", (Object)ZeppelinServer.this.sharedServiceLocator);
            }

            public void contextDestroyed(ServletContextEvent servletContextEvent) {
            }
        });
        this.setupRestApiContextHandler(webApp);
        this.setupPrometheusContextHandler(webApp);
        ZeppelinServer.setupHealthCheckContextHandler(webApp);
        this.setupNotebookServer(webApp);
    }

    private static boolean isNewUiDefault(ZeppelinConfiguration zConf) {
        return zConf.getDefaultUi() == ZeppelinConfiguration.DEFAULT_UI.NEW;
    }

    @Override
    public void close() throws Exception {
        this.shutdown();
    }
}

