/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest;

import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.rest.AbstractRestApi;
import org.apache.zeppelin.rest.message.CredentialRequest;
import org.apache.zeppelin.server.JsonResponse;
import org.apache.zeppelin.service.AuthenticationService;
import org.apache.zeppelin.user.Credentials;
import org.apache.zeppelin.user.UserCredentials;
import org.apache.zeppelin.user.UsernamePassword;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/credential")
@Produces(value={"application/json"})
@Singleton
public class CredentialRestApi
extends AbstractRestApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(CredentialRestApi.class);
    private final Credentials credentials;

    @Inject
    public CredentialRestApi(Credentials credentials, AuthenticationService authenticationService) {
        super(authenticationService);
        this.credentials = credentials;
    }

    @PUT
    public Response putCredentials(String message) {
        CredentialRequest request = (CredentialRequest)GSON.fromJson(message, CredentialRequest.class);
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{request.getEntity(), request.getUsername(), request.getPassword()})) {
            return new JsonResponse(Response.Status.BAD_REQUEST).build();
        }
        String user = this.authenticationService.getPrincipal();
        LOGGER.info("Update credentials for user {} entity {}", (Object)user, (Object)request.getEntity());
        try {
            UserCredentials uc = this.credentials.getUserCredentials(user);
            uc.putUsernamePassword(request.getEntity(), new UsernamePassword(request.getUsername(), request.getPassword()));
            this.credentials.putUserCredentials(user, uc);
            return new JsonResponse(Response.Status.OK).build();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new JsonResponse(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    public Response getCredentials() {
        String user = this.authenticationService.getPrincipal();
        LOGGER.info("getCredentials for user {} ", (Object)user);
        try {
            UserCredentials uc = this.credentials.getUserCredentials(user);
            return new JsonResponse<UserCredentials>(Response.Status.OK, uc).build();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new JsonResponse(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    public Response removeCredentials() {
        String user = this.authenticationService.getPrincipal();
        LOGGER.info("removeCredentials for user {} ", (Object)user);
        try {
            UserCredentials uc = this.credentials.removeUserCredentials(user);
            if (uc == null) {
                return new JsonResponse(Response.Status.NOT_FOUND).build();
            }
            return new JsonResponse(Response.Status.OK).build();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new JsonResponse(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="{entity}")
    public Response removeCredentialEntity(@PathParam(value="entity") String entity) {
        String user = this.authenticationService.getPrincipal();
        LOGGER.info("removeCredentialEntity for user {} entity {}", (Object)user, (Object)entity);
        try {
            if (!this.credentials.removeCredentialEntity(user, entity)) {
                return new JsonResponse(Response.Status.NOT_FOUND).build();
            }
            return new JsonResponse(Response.Status.OK).build();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new JsonResponse(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

