/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.plugin;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.launcher.InterpreterLauncher;
import org.apache.zeppelin.interpreter.launcher.SparkInterpreterLauncher;
import org.apache.zeppelin.interpreter.launcher.StandardInterpreterLauncher;
import org.apache.zeppelin.interpreter.recovery.RecoveryStorage;
import org.apache.zeppelin.notebook.repo.GitNotebookRepo;
import org.apache.zeppelin.notebook.repo.NotebookRepo;
import org.apache.zeppelin.notebook.repo.VFSNotebookRepo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginManager.class);
    private final String pluginsDir;
    private final ZeppelinConfiguration zConf;
    private Map<String, InterpreterLauncher> cachedLaunchers = new HashMap<String, InterpreterLauncher>();
    private List<String> builtinLauncherClassNames = Arrays.asList(StandardInterpreterLauncher.class.getName(), SparkInterpreterLauncher.class.getName());
    private List<String> builtinNotebookRepoClassNames = Arrays.asList(VFSNotebookRepo.class.getName(), GitNotebookRepo.class.getName());

    @Inject
    public PluginManager(ZeppelinConfiguration zConf) {
        this.pluginsDir = zConf.getPluginsDir();
        this.zConf = zConf;
    }

    public NotebookRepo loadNotebookRepo(String notebookRepoClassName) throws IOException {
        LOGGER.info("Loading NotebookRepo Plugin: {}", (Object)notebookRepoClassName);
        if (this.builtinNotebookRepoClassNames.contains(notebookRepoClassName) || Boolean.parseBoolean(System.getProperty("zeppelin.isTest", "false"))) {
            try {
                return (NotebookRepo)Class.forName(notebookRepoClassName).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IOException("Fail to instantiate notebookrepo from classpath directly:" + notebookRepoClassName, e);
            }
        }
        String simpleClassName = notebookRepoClassName.substring(notebookRepoClassName.lastIndexOf(".") + 1);
        URLClassLoader pluginClassLoader = this.getPluginClassLoader(this.pluginsDir, "NotebookRepo", simpleClassName);
        if (pluginClassLoader == null) {
            return null;
        }
        NotebookRepo notebookRepo = null;
        try {
            notebookRepo = (NotebookRepo)Class.forName(notebookRepoClassName, true, pluginClassLoader).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IOException("Fail to instantiate notebookrepo " + notebookRepoClassName + " from plugin classpath:" + this.pluginsDir, e);
        }
        return notebookRepo;
    }

    private String getOldNotebookRepoClassName(String notebookRepoClassName) {
        int pos = notebookRepoClassName.lastIndexOf(".");
        return notebookRepoClassName.substring(0, pos) + ".Old" + notebookRepoClassName.substring(pos + 1);
    }

    public synchronized InterpreterLauncher loadInterpreterLauncher(String launcherPlugin, RecoveryStorage recoveryStorage) throws IOException {
        if (this.cachedLaunchers.containsKey(launcherPlugin)) {
            return this.cachedLaunchers.get(launcherPlugin);
        }
        String launcherClassName = "org.apache.zeppelin.interpreter.launcher." + launcherPlugin;
        LOGGER.info("Loading Interpreter Launcher Plugin: {}", (Object)launcherClassName);
        if (this.builtinLauncherClassNames.contains(launcherClassName) || Boolean.parseBoolean(System.getProperty("zeppelin.isTest", "false"))) {
            try {
                return (InterpreterLauncher)Class.forName(launcherClassName).getConstructor(ZeppelinConfiguration.class, RecoveryStorage.class).newInstance(this.zConf, recoveryStorage);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IOException("Fail to instantiate InterpreterLauncher from classpath directly:" + launcherClassName, e);
            }
        }
        URLClassLoader pluginClassLoader = this.getPluginClassLoader(this.pluginsDir, "Launcher", launcherPlugin);
        InterpreterLauncher launcher = null;
        try {
            launcher = (InterpreterLauncher)Class.forName(launcherClassName, true, pluginClassLoader).getConstructor(ZeppelinConfiguration.class, RecoveryStorage.class).newInstance(this.zConf, recoveryStorage);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException("Fail to instantiate Launcher " + launcherPlugin + " from plugin pluginDir: " + this.pluginsDir, e);
        }
        this.cachedLaunchers.put(launcherPlugin, launcher);
        return launcher;
    }

    private URLClassLoader getPluginClassLoader(String pluginsDir, String pluginType, String pluginName) throws IOException {
        File pluginFolder = new File(pluginsDir + "/" + pluginType + "/" + pluginName);
        if (!pluginFolder.exists() || pluginFolder.isFile()) {
            LOGGER.warn("PluginFolder {} doesn't exist or is not a directory", (Object)pluginFolder.getAbsolutePath());
            return null;
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : pluginFolder.listFiles()) {
            LOGGER.debug("Add file {} to classpath of plugin: {}", (Object)file.getAbsolutePath(), (Object)pluginName);
            urls.add(file.toURI().toURL());
        }
        if (urls.isEmpty()) {
            LOGGER.warn("Can not load plugin {}, because the plugin folder {} is empty.", (Object)pluginName, (Object)pluginFolder);
            return null;
        }
        return new URLClassLoader(urls.toArray(new URL[0]));
    }
}

