/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapterFactory;
import java.util.Date;
import javax.inject.Inject;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.display.Input;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteJsonExclusionStrategy;
import org.apache.zeppelin.notebook.NoteParser;
import org.apache.zeppelin.notebook.NotebookImportDeserializer;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.notebook.exception.CorruptedNoteException;

public class GsonNoteParser
implements NoteParser {
    private final ZeppelinConfiguration zConf;
    private final Gson gson;

    @Inject
    public GsonNoteParser(ZeppelinConfiguration zConf) {
        this.zConf = zConf;
        this.gson = new GsonBuilder().setPrettyPrinting().setDateFormat("yyyy-MM-dd HH:mm:ss.SSS").registerTypeAdapter(Date.class, (Object)new NotebookImportDeserializer()).registerTypeAdapterFactory((TypeAdapterFactory)Input.TypeAdapterFactory).setExclusionStrategies(new ExclusionStrategy[]{new NoteJsonExclusionStrategy(zConf)}).create();
    }

    @Override
    public Note fromJson(String noteId, String json) throws CorruptedNoteException {
        try {
            Note note = (Note)this.gson.fromJson(json, Note.class);
            note.setZeppelinConfiguration(this.zConf);
            note.setNoteParser(this);
            GsonNoteParser.convertOldInput(note);
            note.getInfo().remove("isRunning");
            note.postProcessParagraphs();
            return note;
        }
        catch (JsonSyntaxException e) {
            throw new CorruptedNoteException(noteId, "Fail to parse note json: " + json, (Exception)((Object)e));
        }
    }

    @Override
    public Paragraph fromJson(String json) {
        return (Paragraph)this.gson.fromJson(json, Paragraph.class);
    }

    @Override
    public String toJson(Note note) {
        return this.gson.toJson((Object)note);
    }

    @Override
    public String toJson(Paragraph paragraph) {
        return this.gson.toJson((Object)paragraph);
    }

    private static void convertOldInput(Note note) {
        for (Paragraph p : note.getParagraphs()) {
            p.settings.convertOldInput();
        }
    }
}

