/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.zeppelin.org.eclipse.aether.transport.http;

import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import shaded.org.apache.zeppelin.org.apache.http.conn.ssl.X509HostnameVerifier;

final class X509HostnameVerifierAdapter
implements X509HostnameVerifier {
    private final HostnameVerifier verifier;

    public static X509HostnameVerifier adapt(HostnameVerifier verifier) {
        if (verifier instanceof X509HostnameVerifier) {
            return (X509HostnameVerifier)verifier;
        }
        return new X509HostnameVerifierAdapter(verifier);
    }

    private X509HostnameVerifierAdapter(HostnameVerifier verifier) {
        this.verifier = verifier;
    }

    @Override
    public boolean verify(String hostname, SSLSession session) {
        return this.verifier.verify(hostname, session);
    }

    @Override
    public void verify(String host, SSLSocket socket) throws IOException {
        if (!this.verify(host, socket.getSession())) {
            throw new SSLException("<" + host + "> does not pass hostname verification");
        }
    }

    @Override
    public void verify(String host, X509Certificate cert) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void verify(String host, String[] cns, String[] subjectAlts) {
        throw new UnsupportedOperationException();
    }
}

