/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.zeppelin.org.apache.http.protocol;

import java.io.IOException;
import java.net.InetAddress;
import shaded.org.apache.zeppelin.org.apache.http.HttpConnection;
import shaded.org.apache.zeppelin.org.apache.http.HttpException;
import shaded.org.apache.zeppelin.org.apache.http.HttpHost;
import shaded.org.apache.zeppelin.org.apache.http.HttpInetConnection;
import shaded.org.apache.zeppelin.org.apache.http.HttpRequest;
import shaded.org.apache.zeppelin.org.apache.http.HttpRequestInterceptor;
import shaded.org.apache.zeppelin.org.apache.http.HttpVersion;
import shaded.org.apache.zeppelin.org.apache.http.ProtocolException;
import shaded.org.apache.zeppelin.org.apache.http.ProtocolVersion;
import shaded.org.apache.zeppelin.org.apache.http.annotation.Immutable;
import shaded.org.apache.zeppelin.org.apache.http.protocol.HttpContext;
import shaded.org.apache.zeppelin.org.apache.http.protocol.HttpCoreContext;
import shaded.org.apache.zeppelin.org.apache.http.util.Args;

@Immutable
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext corecontext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targethost = corecontext.getTargetHost();
            if (targethost == null) {
                HttpConnection conn = corecontext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targethost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targethost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targethost.toHostString());
        }
    }
}

