/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.zeppelin.org.apache.http.client.protocol;

import java.io.IOException;
import shaded.org.apache.zeppelin.org.apache.http.HttpEntity;
import shaded.org.apache.zeppelin.org.apache.http.HttpEntityEnclosingRequest;
import shaded.org.apache.zeppelin.org.apache.http.HttpException;
import shaded.org.apache.zeppelin.org.apache.http.HttpRequest;
import shaded.org.apache.zeppelin.org.apache.http.HttpRequestInterceptor;
import shaded.org.apache.zeppelin.org.apache.http.HttpVersion;
import shaded.org.apache.zeppelin.org.apache.http.ProtocolVersion;
import shaded.org.apache.zeppelin.org.apache.http.annotation.Contract;
import shaded.org.apache.zeppelin.org.apache.http.annotation.ThreadingBehavior;
import shaded.org.apache.zeppelin.org.apache.http.client.config.RequestConfig;
import shaded.org.apache.zeppelin.org.apache.http.client.protocol.HttpClientContext;
import shaded.org.apache.zeppelin.org.apache.http.protocol.HttpContext;
import shaded.org.apache.zeppelin.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

