/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.eclipse.sisu.Parameters;
import org.eclipse.sisu.bean.BeanManager;
import org.eclipse.sisu.inject.DeferredProvider;
import org.eclipse.sisu.plexus.DefaultPlexusBeanLocator;
import org.eclipse.sisu.plexus.PlexusAnnotatedBeanModule;
import org.eclipse.sisu.plexus.PlexusBeanConverter;
import org.eclipse.sisu.plexus.PlexusBeanLocator;
import org.eclipse.sisu.plexus.PlexusBeanModule;
import org.eclipse.sisu.plexus.PlexusBindingModule;
import org.eclipse.sisu.plexus.PlexusLifecycleManager;
import org.eclipse.sisu.plexus.PlexusXmlBeanConverter;
import org.eclipse.sisu.plexus.PlexusXmlBeanModule;
import org.eclipse.sisu.plexus.PseudoPlexusContainer;
import org.eclipse.sisu.space.BeanScanning;
import org.eclipse.sisu.space.ClassSpace;
import shaded.org.apache.zeppelin.com.google.inject.Binder;
import shaded.org.apache.zeppelin.com.google.inject.Module;
import shaded.org.apache.zeppelin.org.codehaus.plexus.PlexusContainer;
import shaded.org.apache.zeppelin.org.codehaus.plexus.context.Context;
import shaded.org.apache.zeppelin.org.codehaus.plexus.context.ContextMapAdapter;
import shaded.org.apache.zeppelin.org.codehaus.plexus.context.DefaultContext;
import shaded.org.apache.zeppelin.org.codehaus.plexus.logging.LoggerManager;

public final class PlexusSpaceModule
implements Module {
    private final ClassSpace space;
    private final BeanScanning scanning;
    private BeanManager delegate;

    public PlexusSpaceModule(ClassSpace space) {
        this(space, BeanScanning.OFF);
    }

    public PlexusSpaceModule(ClassSpace space, BeanScanning scanning) {
        this.space = space;
        this.scanning = scanning;
    }

    public void configure(Binder binder) {
        ParameterizedContext context = new ParameterizedContext();
        binder.bind(Context.class).toInstance((Object)context);
        DeferredProvider<?> slf4jLoggerFactoryProvider = this.space.deferLoadClass("shaded/org/apache/zeppelin/org.slf4j.ILoggerFactory").asProvider();
        binder.requestInjection(slf4jLoggerFactoryProvider);
        binder.bind(PlexusBeanConverter.class).to(PlexusXmlBeanConverter.class);
        binder.bind(PlexusBeanLocator.class).to(DefaultPlexusBeanLocator.class);
        binder.bind(PlexusContainer.class).to(PseudoPlexusContainer.class);
        BeanManager manager = this.delegate instanceof PlexusLifecycleManager ? this.delegate : new PlexusLifecycleManager((Provider<Context>)binder.getProvider(Context.class), (Provider<LoggerManager>)binder.getProvider(LoggerManager.class), (Provider<?>)((Object)slf4jLoggerFactoryProvider), this.delegate);
        binder.bind(BeanManager.class).toInstance((Object)manager);
        ArrayList<PlexusBeanModule> beanModules = new ArrayList<PlexusBeanModule>();
        ContextMapAdapter variables = new ContextMapAdapter(context);
        beanModules.add(new PlexusXmlBeanModule(this.space, variables));
        beanModules.add(new PlexusAnnotatedBeanModule(this.space, variables, this.scanning));
        binder.install((Module)new PlexusBindingModule(manager, beanModules));
    }

    public PlexusSpaceModule with(BeanManager manager) {
        this.delegate = manager;
        return this;
    }

    static final class ParameterizedContext
    extends DefaultContext {
        ParameterizedContext() {
        }

        @Inject
        protected void setParameters(@Parameters Map parameters, PlexusContainer container) {
            this.contextData.putAll(parameters);
            this.contextData.put("plexus", container);
        }
    }
}

