/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import org.eclipse.sisu.inject.BindingPublisher;
import org.eclipse.sisu.inject.InjectorBindings;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.launch.BundleModule;
import org.eclipse.sisu.launch.BundlePlan;
import org.eclipse.sisu.plexus.PlexusSpaceModule;
import org.eclipse.sisu.space.BeanScanning;
import shaded.org.apache.zeppelin.com.google.inject.Guice;
import shaded.org.apache.zeppelin.com.google.inject.Module;
import shaded.org.apache.zeppelin.org.osgi.framework.Bundle;
import shaded.org.apache.zeppelin.org.osgi.framework.FrameworkUtil;

public class PlexusBundlePlan
implements BundlePlan {
    private static final String SUPPORT_BUNDLE_NAME = FrameworkUtil.getBundle(PlexusSpaceModule.class).getSymbolicName();
    protected final MutableBeanLocator locator;

    public PlexusBundlePlan(MutableBeanLocator locator) {
        this.locator = locator;
    }

    @Override
    public BindingPublisher prepare(Bundle bundle) {
        if (!SUPPORT_BUNDLE_NAME.equals(bundle.getSymbolicName()) && (PlexusBundlePlan.hasPlexusAnnotations(bundle) || PlexusBundlePlan.hasPlexusXml(bundle))) {
            return new InjectorBindings(Guice.createInjector((Module[])new Module[]{new BundleModule(bundle, this.locator){

                @Override
                protected Module spaceModule() {
                    return new PlexusSpaceModule(this.space, BeanScanning.select(this.getProperties()));
                }
            }}));
        }
        return null;
    }

    protected static boolean hasPlexusAnnotations(Bundle bundle) {
        String imports = (String)bundle.getHeaders().get("Import-Package");
        return imports != null && imports.contains("shaded.org.apache.zeppelin.org.codehaus.plexus.component.annotations");
    }

    protected static boolean hasPlexusXml(Bundle bundle) {
        return bundle.findEntries("META-INF/plexus", "components.xml", false) != null;
    }
}

