/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.util;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.zeppelin.org.apache.commons.lang3.StringUtils;
import shaded.org.apache.zeppelin.org.apache.commons.lang3.exception.ExceptionUtils;

public abstract class ProcessLauncher
implements ExecuteResultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessLauncher.class);
    private CommandLine commandLine;
    private Map<String, String> envs;
    private ExecuteWatchdog watchdog;
    private ProcessLogOutputStream processOutput;
    protected String errorMessage = null;
    protected volatile State state = State.NEW;
    private boolean launchTimeout = false;

    public ProcessLauncher(CommandLine commandLine, Map<String, String> envs) {
        this.commandLine = commandLine;
        this.envs = envs;
        this.processOutput = new ProcessLogOutputStream();
    }

    public ProcessLauncher(CommandLine commandLine, Map<String, String> envs, ProcessLogOutputStream processLogOutput) {
        this.commandLine = commandLine;
        this.envs = envs;
        this.processOutput = processLogOutput;
    }

    public void setRedirectedContext(InterpreterContext redirectedContext) {
        if (redirectedContext != null) {
            LOGGER.info("Start to redirect process output to interpreter output");
        } else {
            LOGGER.info("Stop to redirect process output to interpreter output");
        }
        this.processOutput.redirectedContext = redirectedContext;
    }

    public void launch() {
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler(new PumpStreamHandler(this.processOutput));
        this.watchdog = new ExecuteWatchdog(-1L);
        executor.setWatchdog(this.watchdog);
        try {
            executor.execute(this.commandLine, this.envs, this);
            this.transition(State.LAUNCHED);
            LOGGER.info("Process is launched: {}", (Object)this.commandLine);
        }
        catch (IOException e) {
            this.processOutput.stopCatchLaunchOutput();
            LOGGER.error("Fail to launch process: {}", (Object)this.commandLine, (Object)e);
            this.transition(State.TERMINATED);
            this.errorMessage = e.getMessage();
        }
    }

    public abstract void waitForReady(int var1);

    public void transition(State state) {
        this.state = state;
        LOGGER.info("Process state is transitioned to {}", (Object)state);
    }

    public void onTimeout() {
        LOGGER.warn("Process launch is time out.");
        this.launchTimeout = true;
        this.stop();
    }

    public void onProcessRunning() {
        this.transition(State.RUNNING);
    }

    @Override
    public void onProcessComplete(int exitValue) {
        LOGGER.warn("Process is exited with exit value {}", (Object)exitValue);
        if (exitValue == 0) {
            this.transition(State.COMPLETED);
        } else {
            this.transition(State.TERMINATED);
        }
    }

    @Override
    public void onProcessFailed(ExecuteException e) {
        LOGGER.warn("Process with cmd {} is failed due to", (Object)this.commandLine, (Object)e);
        LOGGER.warn("Process ErrorMessage: \n{}", (Object)this.getErrorMessage());
        this.errorMessage = ExceptionUtils.getStackTrace(e);
        this.transition(State.TERMINATED);
    }

    public String getErrorMessage() {
        if (!StringUtils.isBlank(this.processOutput.getProcessExecutionOutput())) {
            return this.processOutput.getProcessExecutionOutput();
        }
        return this.errorMessage;
    }

    public String getProcessLaunchOutput() {
        return this.processOutput.getProcessExecutionOutput();
    }

    public boolean isLaunchTimeout() {
        return this.launchTimeout;
    }

    public boolean isAlive() {
        return this.state != State.TERMINATED && this.state != State.COMPLETED;
    }

    public boolean isRunning() {
        return this.state == State.RUNNING;
    }

    public void stop() {
        if (this.watchdog != null && this.isRunning()) {
            this.watchdog.destroyProcess();
            this.watchdog = null;
        }
    }

    public void stopCatchLaunchOutput() {
        this.processOutput.stopCatchLaunchOutput();
    }

    public static class ProcessLogOutputStream
    extends LogOutputStream {
        private boolean catchLaunchOutput = true;
        private StringBuilder launchOutput = new StringBuilder();
        private InterpreterContext redirectedContext;

        public void stopCatchLaunchOutput() {
            this.catchLaunchOutput = false;
        }

        public String getProcessExecutionOutput() {
            return this.launchOutput.toString();
        }

        @Override
        protected void processLine(String s, int i) {
            if (s.startsWith("[INFO]")) {
                LOGGER.info(s);
            } else {
                LOGGER.debug("Process Output: {}", (Object)s);
            }
            if (this.catchLaunchOutput) {
                this.launchOutput.append(s + "\n");
            }
            if (this.redirectedContext != null) {
                try {
                    this.redirectedContext.out.write(s + "\n");
                }
                catch (IOException e) {
                    LOGGER.error("unable to write to redirectedContext", (Throwable)e);
                }
            }
        }
    }

    public static enum State {
        NEW,
        LAUNCHED,
        RUNNING,
        TERMINATED,
        COMPLETED;

    }
}

