/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.graph;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.tabledata.Node;
import org.apache.zeppelin.tabledata.Relationship;
import shaded.org.apache.zeppelin.com.google.gson.Gson;

public class GraphResult
extends InterpreterResult {
    private static final Gson gson = new Gson();

    public GraphResult(InterpreterResult.Code code, Graph graphObject) {
        super(code, InterpreterResult.Type.NETWORK, gson.toJson(graphObject));
    }

    public static class Graph {
        private Collection<Node> nodes;
        private Collection<Relationship> edges;
        private Map<String, String> labels;
        private Set<String> types;
        private boolean directed;

        public Graph() {
        }

        public Graph(Collection<Node> nodes, Collection<Relationship> edges, Map<String, String> labels, Set<String> types, boolean directed) {
            this.setNodes(nodes);
            this.setEdges(edges);
            this.setLabels(labels);
            this.setTypes(types);
            this.setDirected(directed);
        }

        public Collection<Node> getNodes() {
            return this.nodes;
        }

        public void setNodes(Collection<Node> nodes) {
            this.nodes = nodes;
        }

        public Collection<Relationship> getEdges() {
            return this.edges;
        }

        public void setEdges(Collection<Relationship> edges) {
            this.edges = edges;
        }

        public Map<String, String> getLabels() {
            return this.labels;
        }

        public void setLabels(Map<String, String> labels) {
            this.labels = labels;
        }

        public Set<String> getTypes() {
            return this.types;
        }

        public void setTypes(Set<String> types) {
            this.types = types;
        }

        public boolean isDirected() {
            return this.directed;
        }

        public void setDirected(boolean directed) {
            this.directed = directed;
        }
    }
}

