/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.dep;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.dep.AbstractDependencyResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.zeppelin.org.apache.commons.io.FileUtils;
import shaded.org.apache.zeppelin.org.apache.commons.lang3.StringUtils;
import shaded.org.apache.zeppelin.org.eclipse.aether.RepositoryException;
import shaded.org.apache.zeppelin.org.eclipse.aether.artifact.Artifact;
import shaded.org.apache.zeppelin.org.eclipse.aether.artifact.DefaultArtifact;
import shaded.org.apache.zeppelin.org.eclipse.aether.collection.CollectRequest;
import shaded.org.apache.zeppelin.org.eclipse.aether.graph.Dependency;
import shaded.org.apache.zeppelin.org.eclipse.aether.graph.DependencyFilter;
import shaded.org.apache.zeppelin.org.eclipse.aether.repository.Proxy;
import shaded.org.apache.zeppelin.org.eclipse.aether.repository.RemoteRepository;
import shaded.org.apache.zeppelin.org.eclipse.aether.resolution.ArtifactResult;
import shaded.org.apache.zeppelin.org.eclipse.aether.resolution.DependencyRequest;
import shaded.org.apache.zeppelin.org.eclipse.aether.resolution.DependencyResolutionException;
import shaded.org.apache.zeppelin.org.eclipse.aether.util.filter.DependencyFilterUtils;
import shaded.org.apache.zeppelin.org.eclipse.aether.util.filter.PatternExclusionsDependencyFilter;

public class DependencyResolver
extends AbstractDependencyResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyResolver.class);
    private final String[] exclusions = new String[]{"shaded.org.apache.zeppelin.org.apache.zeppelin:zeppelin-zengine", "shaded.org.apache.zeppelin.org.apache.zeppelin:zeppelin-interpreter", "shaded.org.apache.zeppelin.org.apache.zeppelin:zeppelin-server"};

    public DependencyResolver(String localRepoPath, ZeppelinConfiguration zConf) {
        super(localRepoPath, zConf);
    }

    public DependencyResolver(String localRepoPath, Proxy proxy, ZeppelinConfiguration zConf) {
        super(localRepoPath, proxy, zConf);
    }

    public List<File> load(String artifact) throws RepositoryException {
        return this.load(artifact, new LinkedList<String>());
    }

    public synchronized List<File> load(String artifact, Collection<String> excludes) throws RepositoryException {
        if (StringUtils.isBlank(artifact)) {
            return new LinkedList<File>();
        }
        int numSplits = artifact.split(":").length;
        if (numSplits >= 3 && numSplits <= 6) {
            return this.loadFromMvn(artifact, excludes);
        }
        LinkedList<File> libs = new LinkedList<File>();
        libs.add(new File(artifact));
        return libs;
    }

    public List<File> load(String artifact, File destPath) throws IOException, RepositoryException {
        return this.load(artifact, new LinkedList<String>(), destPath);
    }

    public List<File> load(String artifact, Collection<String> excludes, File destPath) throws RepositoryException, IOException {
        List<File> libs = new LinkedList<File>();
        if (StringUtils.isNotBlank(artifact)) {
            libs = this.load(artifact, excludes);
            for (File srcFile : libs) {
                File destFile = new File(destPath, srcFile.getName());
                if (destFile.exists() && FileUtils.contentEquals(srcFile, destFile)) continue;
                FileUtils.copyFile(srcFile, destFile);
                LOGGER.debug("copy {} to {}", (Object)srcFile.getAbsolutePath(), (Object)destPath);
            }
        }
        return libs;
    }

    public synchronized void copyLocalDependency(String srcPath, File destPath) throws IOException {
        if (StringUtils.isBlank(srcPath)) {
            return;
        }
        File srcFile = new File(srcPath);
        File destFile = new File(destPath, srcFile.getName());
        if (!destFile.exists() || !FileUtils.contentEquals(srcFile, destFile)) {
            FileUtils.copyFile(srcFile, destFile);
            LOGGER.debug("copy {} to {}", (Object)srcFile.getAbsolutePath(), (Object)destPath);
        }
    }

    private List<File> loadFromMvn(String artifact, Collection<String> excludes) throws RepositoryException {
        LinkedList<String> allExclusions = new LinkedList<String>();
        allExclusions.addAll(excludes);
        allExclusions.addAll(Arrays.asList(this.exclusions));
        List<ArtifactResult> listOfArtifact = this.getArtifactsWithDep(artifact, allExclusions);
        Iterator<ArtifactResult> it = listOfArtifact.iterator();
        block0: while (it.hasNext()) {
            Artifact a = it.next().getArtifact();
            String gav = a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getVersion();
            for (String exclude : allExclusions) {
                if (!gav.startsWith(exclude)) continue;
                it.remove();
                continue block0;
            }
        }
        LinkedList<File> files = new LinkedList<File>();
        for (ArtifactResult artifactResult : listOfArtifact) {
            files.add(artifactResult.getArtifact().getFile());
            LOGGER.debug("load {}", (Object)artifactResult.getArtifact().getFile().getAbsolutePath());
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ArtifactResult> getArtifactsWithDep(String dependency, Collection<String> excludes) throws RepositoryException {
        DefaultArtifact artifact = new DefaultArtifact(dependency);
        DependencyFilter classpathFilter = DependencyFilterUtils.classpathFilter("compile");
        PatternExclusionsDependencyFilter exclusionFilter = new PatternExclusionsDependencyFilter(excludes);
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency(artifact, "compile"));
        List list = this.repos;
        synchronized (list) {
            for (RemoteRepository repo : this.repos) {
                collectRequest.addRepository(repo);
            }
        }
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, DependencyFilterUtils.andFilter(exclusionFilter, classpathFilter));
        try {
            return this.system.resolveDependencies(this.session, dependencyRequest).getArtifactResults();
        }
        catch (NullPointerException | DependencyResolutionException ex) {
            throw new RepositoryException(String.format("Cannot fetch dependencies for %s", dependency), ex);
        }
    }
}

