/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uniffle.com.google.common.collect.Maps;
import org.apache.uniffle.com.google.common.collect.Sets;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.util.JavaUtils;

public class ShuffleHandleInfo
implements Serializable {
    private int shuffleId;
    private Map<Integer, List<ShuffleServerInfo>> partitionToServers;
    private Map<Integer, Map<Integer, ShuffleServerInfo>> failoverPartitionServers;
    private Map<String, ShuffleServerInfo> faultyServerReplacements;
    private Set<ShuffleServerInfo> shuffleServersForData;
    private RemoteStorageInfo remoteStorage;
    public static final ShuffleHandleInfo EMPTY_HANDLE_INFO = new ShuffleHandleInfo(-1, Collections.EMPTY_MAP, RemoteStorageInfo.EMPTY_REMOTE_STORAGE);

    public ShuffleHandleInfo(int shuffleId, Map<Integer, List<ShuffleServerInfo>> partitionToServers, RemoteStorageInfo storageInfo) {
        this.shuffleId = shuffleId;
        this.partitionToServers = partitionToServers;
        this.shuffleServersForData = Sets.newHashSet();
        this.failoverPartitionServers = Maps.newConcurrentMap();
        for (List<ShuffleServerInfo> ssis : partitionToServers.values()) {
            this.shuffleServersForData.addAll(ssis);
        }
        this.remoteStorage = storageInfo;
        this.faultyServerReplacements = JavaUtils.newConcurrentMap();
    }

    public Map<Integer, List<ShuffleServerInfo>> getPartitionToServers() {
        return this.partitionToServers;
    }

    public Set<ShuffleServerInfo> getShuffleServersForData() {
        return this.shuffleServersForData;
    }

    public RemoteStorageInfo getRemoteStorage() {
        return this.remoteStorage;
    }

    public int getShuffleId() {
        return this.shuffleId;
    }

    public boolean isExistingFaultyServer(String serverId) {
        return this.faultyServerReplacements.containsKey(serverId);
    }

    public ShuffleServerInfo useExistingReassignmentForMultiPartitions(Set<Integer> partitionIds, String faultyServerId) {
        return this.createNewReassignmentForMultiPartitions(partitionIds, faultyServerId, null);
    }

    public ShuffleServerInfo createNewReassignmentForMultiPartitions(Set<Integer> partitionIds, String faultyServerId, ShuffleServerInfo replacement) {
        if (replacement != null) {
            this.faultyServerReplacements.put(faultyServerId, replacement);
        }
        replacement = this.faultyServerReplacements.get(faultyServerId);
        for (Integer partitionId : partitionIds) {
            List<ShuffleServerInfo> replicaServers = this.partitionToServers.get(partitionId);
            for (int i = 0; i < replicaServers.size(); ++i) {
                if (!replicaServers.get(i).getId().equals(faultyServerId)) continue;
                Map replicaReplacements = this.failoverPartitionServers.computeIfAbsent(partitionId, k -> JavaUtils.newConcurrentMap());
                replicaReplacements.put(i, replacement);
            }
        }
        return replacement;
    }
}

