/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler.impl;

import org.apache.uniffle.client.api.ShuffleServerClient;
import org.apache.uniffle.client.request.RssGetShuffleDataRequest;
import org.apache.uniffle.client.request.RssGetShuffleIndexRequest;
import org.apache.uniffle.client.response.RssGetShuffleDataResponse;
import org.apache.uniffle.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.ShuffleDataResult;
import org.apache.uniffle.common.ShuffleDataSegment;
import org.apache.uniffle.common.ShuffleIndexResult;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.exception.RssFetchFailedException;
import org.apache.uniffle.org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.apache.uniffle.storage.handler.impl.DataSkippableReadHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileClientReadHandler
extends DataSkippableReadHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LocalFileClientReadHandler.class);
    private final int partitionNumPerRange;
    private final int partitionNum;
    private ShuffleServerClient shuffleServerClient;
    private int retryMax;
    private long retryIntervalMax;

    public LocalFileClientReadHandler(String appId, int shuffleId, int partitionId, int indexReadLimit, int partitionNumPerRange, int partitionNum, int readBufferSize, Roaring64NavigableMap expectBlockIds, Roaring64NavigableMap processBlockIds, ShuffleServerClient shuffleServerClient, ShuffleDataDistributionType distributionType, Roaring64NavigableMap expectTaskIds, int retryMax, long retryIntervalMax) {
        super(appId, shuffleId, partitionId, readBufferSize, expectBlockIds, processBlockIds, distributionType, expectTaskIds);
        this.shuffleServerClient = shuffleServerClient;
        this.partitionNumPerRange = partitionNumPerRange;
        this.partitionNum = partitionNum;
        this.retryMax = retryMax;
        this.retryIntervalMax = retryIntervalMax;
    }

    @VisibleForTesting
    public LocalFileClientReadHandler(String appId, int shuffleId, int partitionId, int indexReadLimit, int partitionNumPerRange, int partitionNum, int readBufferSize, Roaring64NavigableMap expectBlockIds, Roaring64NavigableMap processBlockIds, ShuffleServerClient shuffleServerClient) {
        this(appId, shuffleId, partitionId, indexReadLimit, partitionNumPerRange, partitionNum, readBufferSize, expectBlockIds, processBlockIds, shuffleServerClient, ShuffleDataDistributionType.NORMAL, Roaring64NavigableMap.bitmapOf(new long[0]), 1, 0L);
    }

    @Override
    public ShuffleIndexResult readShuffleIndex() {
        ShuffleIndexResult shuffleIndexResult = null;
        RssGetShuffleIndexRequest request = new RssGetShuffleIndexRequest(this.appId, this.shuffleId, this.partitionId, this.partitionNumPerRange, this.partitionNum, this.retryMax, this.retryIntervalMax);
        try {
            shuffleIndexResult = this.shuffleServerClient.getShuffleIndex(request).getShuffleIndexResult();
        }
        catch (RssFetchFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RssFetchFailedException("Failed to read shuffle index for appId[" + this.appId + "], shuffleId[" + this.shuffleId + "], partitionId[" + this.partitionId + "]", e);
        }
        return shuffleIndexResult;
    }

    @Override
    public ShuffleDataResult readShuffleData(ShuffleDataSegment shuffleDataSegment) {
        ShuffleDataResult result = null;
        int expectedLength = shuffleDataSegment.getLength();
        if (expectedLength <= 0) {
            throw new RssException("Failed to read shuffle data for appId[" + this.appId + "], shuffleId[" + this.shuffleId + "], partitionId[" + this.partitionId + "], the length field in the index segment is " + expectedLength + " <= 0!");
        }
        RssGetShuffleDataRequest request = new RssGetShuffleDataRequest(this.appId, this.shuffleId, this.partitionId, this.partitionNumPerRange, this.partitionNum, shuffleDataSegment.getOffset(), expectedLength, this.retryMax, this.retryIntervalMax);
        try {
            RssGetShuffleDataResponse response = this.shuffleServerClient.getShuffleData(request);
            result = new ShuffleDataResult(response.getShuffleData(), shuffleDataSegment.getBufferSegments());
        }
        catch (Exception e) {
            throw new RssException("Failed to read shuffle data with " + this.shuffleServerClient.getClientInfo(), e);
        }
        if (result.getDataBuffer().remaining() != expectedLength) {
            throw new RssException("Wrong data length expect " + result.getDataBuffer().remaining() + " but actual is " + expectedLength);
        }
        return result;
    }
}

