/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.IFile;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Merger;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapreduce.CryptoUtils;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.reduce.ExceptionReporter;
import org.apache.hadoop.mapreduce.task.reduce.InMemoryMapOutput;
import org.apache.hadoop.mapreduce.task.reduce.InMemoryReader;
import org.apache.hadoop.mapreduce.task.reduce.MergeThread;
import org.apache.hadoop.mapreduce.task.reduce.RssRemoteMergeManagerImpl;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

public class RssInMemoryRemoteMerger<K, V>
extends MergeThread<InMemoryMapOutput<K, V>, K, V> {
    private static final Log LOG = LogFactory.getLog(RssInMemoryRemoteMerger.class);
    private static final String SPILL_OUTPUT_PREFIX = "spill";
    private final RssRemoteMergeManagerImpl<K, V> manager;
    private final JobConf jobConf;
    private final FileSystem remoteFs;
    private final Path spillPath;
    private final String taskAttemptId;
    private final CompressionCodec codec;
    private final Progressable reporter;
    private final Counters.Counter spilledRecordsCounter;
    private final Class<? extends Reducer> combinerClass;
    private final Task.CombineOutputCollector<K, V> combineCollector;
    private final Counters.Counter reduceCombineInputCounter;
    private final Counters.Counter mergedMapOutputsCounter;

    public RssInMemoryRemoteMerger(RssRemoteMergeManagerImpl<K, V> manager, JobConf jobConf, FileSystem remoteFs, Path spillPath, String taskId, CompressionCodec codec, Progressable reporter, Counters.Counter spilledRecordsCounter, Class<? extends Reducer> combinerClass, ExceptionReporter exceptionReporter, Task.CombineOutputCollector<K, V> combineCollector, Counters.Counter reduceCombineInputCounter, Counters.Counter mergedMapOutputsCounter) {
        super(manager, Integer.MAX_VALUE, exceptionReporter);
        this.setName("RssInMemoryMerger - Thread to merge in-memory map-outputs");
        this.setDaemon(true);
        this.manager = manager;
        this.jobConf = jobConf;
        this.remoteFs = remoteFs;
        this.spillPath = spillPath;
        this.taskAttemptId = taskId;
        this.codec = codec;
        this.reporter = reporter;
        this.spilledRecordsCounter = spilledRecordsCounter;
        this.combinerClass = combinerClass;
        this.combineCollector = combineCollector;
        this.reduceCombineInputCounter = reduceCombineInputCounter;
        this.mergedMapOutputsCounter = mergedMapOutputsCounter;
    }

    public void merge(List<InMemoryMapOutput<K, V>> inputs) throws IOException {
        if (inputs == null || inputs.size() == 0) {
            return;
        }
        long start = System.currentTimeMillis();
        TaskAttemptID mapId = inputs.get(0).getMapId();
        ArrayList<Merger.Segment<K, V>> inMemorySegments = new ArrayList<Merger.Segment<K, V>>();
        this.createInMemorySegments(inputs, inMemorySegments);
        int noInMemorySegments = inMemorySegments.size();
        String filePath = "spill/" + this.taskAttemptId + "/" + mapId;
        Path outputPath = new Path(this.spillPath, filePath);
        FSDataOutputStream out = CryptoUtils.wrapIfNecessary((Configuration)this.jobConf, (FSDataOutputStream)this.remoteFs.create(outputPath));
        IFile.Writer writer = new IFile.Writer((Configuration)this.jobConf, out, this.jobConf.getMapOutputKeyClass(), this.jobConf.getMapOutputValueClass(), this.codec, null, true);
        RawKeyValueIterator rIter = null;
        try {
            LOG.info((Object)("Initiating in-memory merge with " + noInMemorySegments + " segments..."));
            rIter = Merger.merge((Configuration)this.jobConf, (FileSystem)this.remoteFs, (Class)this.jobConf.getMapOutputKeyClass(), (Class)this.jobConf.getMapOutputValueClass(), inMemorySegments, (int)inMemorySegments.size(), (Path)new Path(this.taskAttemptId), (RawComparator)this.jobConf.getOutputKeyComparator(), (Progressable)this.reporter, (Counters.Counter)this.spilledRecordsCounter, null, null);
            if (null == this.combinerClass) {
                Merger.writeFile((RawKeyValueIterator)rIter, (IFile.Writer)writer, (Progressable)this.reporter, (Configuration)this.jobConf);
            } else {
                this.combineCollector.setWriter(writer);
                this.combineAndSpill(rIter, this.reduceCombineInputCounter);
            }
            writer.close();
            this.manager.closeOnHDFSFile(outputPath);
            LOG.info((Object)(this.taskAttemptId + " Merge of the " + noInMemorySegments + " files in-memory complete. Local file is " + outputPath + " of size " + this.remoteFs.getFileStatus(outputPath).getLen() + " cost time " + (System.currentTimeMillis() - start) + " ms"));
        }
        catch (IOException e) {
            this.remoteFs.delete(outputPath, true);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void combineAndSpill(RawKeyValueIterator kvIter, Counters.Counter inCounter) throws IOException {
        JobConf job = this.jobConf;
        Reducer combiner = (Reducer)ReflectionUtils.newInstance(this.combinerClass, (Configuration)job);
        Class keyClass = job.getMapOutputKeyClass();
        Class valClass = job.getMapOutputValueClass();
        RawComparator comparator = job.getCombinerKeyGroupingComparator();
        try {
            Task.CombineValuesIterator values = new Task.CombineValuesIterator(kvIter, comparator, keyClass, valClass, (Configuration)job, Reporter.NULL, inCounter);
            while (values.more()) {
                combiner.reduce(values.getKey(), (Iterator)values, this.combineCollector, Reporter.NULL);
                values.nextKey();
            }
        }
        finally {
            combiner.close();
        }
    }

    private long createInMemorySegments(List<InMemoryMapOutput<K, V>> inMemoryMapOutputs, List<Merger.Segment<K, V>> inMemorySegments) throws IOException {
        long totalSize = 0L;
        long fullSize = 0L;
        for (InMemoryMapOutput<K, V> mo : inMemoryMapOutputs) {
            fullSize += (long)mo.getMemory().length;
        }
        while (fullSize > 0L) {
            InMemoryMapOutput<K, V> mo = inMemoryMapOutputs.remove(0);
            byte[] data = mo.getMemory();
            long size = data.length;
            totalSize += size;
            fullSize -= size;
            InMemoryReader reader = new InMemoryReader(this.manager, mo.getMapId(), data, 0, (int)size, (Configuration)this.jobConf);
            inMemorySegments.add(new Merger.Segment((IFile.Reader)reader, true, this.mergedMapOutputsCounter));
        }
        return totalSize;
    }
}

