/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.rpc;

import javax.annotation.Nullable;
import org.apache.uniffle.shaded.io.grpc.ForwardingServerCallListener;
import org.apache.uniffle.shaded.io.grpc.Grpc;
import org.apache.uniffle.shaded.io.grpc.Metadata;
import org.apache.uniffle.shaded.io.grpc.ServerCall;
import org.apache.uniffle.shaded.io.grpc.ServerCallHandler;
import org.apache.uniffle.shaded.io.grpc.ServerInterceptor;

public class ClientContextServerInterceptor
implements ServerInterceptor {
    private static final ThreadLocal<String> IP_ADDRESS_THREAD_LOCAL = new ThreadLocal();

    @Nullable
    public static String getIpAddress() {
        return IP_ADDRESS_THREAD_LOCAL.get();
    }

    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(final ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        this.setRemoteIpAddress(call);
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(next.startCall(call, headers)){

            @Override
            public void onHalfClose() {
                ClientContextServerInterceptor.this.setRemoteIpAddress(call);
                super.onHalfClose();
            }
        };
    }

    private <ReqT, RespT> void setRemoteIpAddress(ServerCall<ReqT, RespT> call) {
        String remoteIpAddress = call.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR).toString();
        IP_ADDRESS_THREAD_LOCAL.set(remoteIpAddress);
    }
}

