/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.compression;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdCompressCtx;
import java.nio.ByteBuffer;
import org.apache.uniffle.common.compression.Codec;
import org.apache.uniffle.common.config.RssClientConf;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.exception.RssException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZstdCodec
extends Codec {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZstdCodec.class);
    private int compressionLevel;
    private int workerNumber;

    public static ZstdCodec getInstance(RssConf conf) {
        LazyHolder.INSTANCE.compressionLevel = conf.get(RssClientConf.ZSTD_COMPRESSION_LEVEL);
        LazyHolder.INSTANCE.workerNumber = conf.get(RssClientConf.ZSTD_COMPRESSION_WORKER_NUMBER);
        return LazyHolder.INSTANCE;
    }

    @Override
    public void decompress(ByteBuffer src, int uncompressedLen, ByteBuffer dst, int dstOffset) {
        if (src.isDirect() && dst.isDirect()) {
            long size = Zstd.decompressDirectByteBuffer((ByteBuffer)dst, (int)dstOffset, (int)uncompressedLen, (ByteBuffer)src, (int)src.position(), (int)(src.limit() - src.position()));
            if (size != (long)uncompressedLen) {
                throw new RssException("This should not happen that the decompressed data size is not equals to original size.");
            }
            return;
        }
        if (!src.isDirect() && !dst.isDirect()) {
            Zstd.decompressByteArray((byte[])dst.array(), (int)dstOffset, (int)uncompressedLen, (byte[])src.array(), (int)src.position(), (int)(src.limit() - src.position()));
            return;
        }
        throw new IllegalStateException("Zstd only supports the same type of bytebuffer decompression.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] compress(byte[] src) {
        try (ZstdCompressCtx ctx = new ZstdCompressCtx();){
            ctx.setLevel(this.compressionLevel);
            if (this.workerNumber > 0) {
                ctx.setWorkers(this.workerNumber);
            }
            byte[] byArray = ctx.compress(src);
            return byArray;
        }
    }

    @Override
    public int compress(ByteBuffer src, ByteBuffer dest) {
        try {
            if (src.isDirect() && dest.isDirect()) {
                return Zstd.compress((ByteBuffer)dest, (ByteBuffer)src.duplicate(), (int)this.compressionLevel);
            }
            if (!src.isDirect() && !dest.isDirect()) {
                int destOff = dest.position();
                int compressedSize = (int)Zstd.compressByteArray((byte[])dest.array(), (int)dest.position(), (int)dest.remaining(), (byte[])src.array(), (int)src.position(), (int)src.remaining(), (int)this.compressionLevel);
                dest.position(destOff + compressedSize);
                return compressedSize;
            }
        }
        catch (Exception e) {
            throw new RssException("Failed to compress by Zstd", e);
        }
        throw new IllegalStateException("Zstd only supports the same type of bytebuffer compression.");
    }

    @Override
    public int maxCompressedLength(int sourceLength) {
        return (int)Zstd.compressBound((long)sourceLength);
    }

    private static class LazyHolder {
        static final ZstdCodec INSTANCE = new ZstdCodec();

        private LazyHolder() {
        }
    }
}

