/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uniffle.common.config.RssConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconfigurableRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(ReconfigurableRegistry.class);
    private static final HashMap<Set<String>, List<ReconfigureListener>> LISTENER_MAP = new HashMap();

    private ReconfigurableRegistry() {
    }

    public static synchronized void register(ReconfigureListener listener) {
        ReconfigurableRegistry.register(Collections.emptySet(), listener);
    }

    public static synchronized void register(String key, ReconfigureListener listener) {
        ReconfigurableRegistry.register(Sets.newHashSet((Object[])new String[]{key}), listener);
    }

    public static synchronized void register(Set<String> keys, ReconfigureListener listener) {
        List listenerList = LISTENER_MAP.computeIfAbsent(keys, k -> new ArrayList());
        listenerList.add(listener);
    }

    public static synchronized boolean unregister(String key) {
        return ReconfigurableRegistry.unregister(Sets.newHashSet((Object[])new String[]{key}));
    }

    public static synchronized boolean unregister(Set<String> keys) {
        return LISTENER_MAP.remove(keys) != null;
    }

    public static synchronized boolean unregister(String key, ReconfigureListener listener) {
        return ReconfigurableRegistry.unregister(Sets.newHashSet((Object[])new String[]{key}), listener);
    }

    public static synchronized boolean unregister(Set<String> keys, ReconfigureListener listener) {
        List<ReconfigureListener> listenerList = LISTENER_MAP.get(keys);
        if (listenerList == null) {
            return false;
        }
        boolean removed = listenerList.remove(listener);
        if (listenerList.isEmpty()) {
            LISTENER_MAP.remove(keys);
        }
        return removed;
    }

    public static synchronized boolean unregister(ReconfigureListener listener) {
        boolean removed;
        block1: {
            Map.Entry<Set<String>, List<ReconfigureListener>> entry;
            removed = ReconfigurableRegistry.unregister(Collections.emptySet(), listener);
            if (removed) break block1;
            Iterator<Map.Entry<Set<String>, List<ReconfigureListener>>> iterator = LISTENER_MAP.entrySet().iterator();
            while (iterator.hasNext() && !(removed = ReconfigurableRegistry.unregister((entry = iterator.next()).getKey(), listener))) {
            }
        }
        return removed;
    }

    @VisibleForTesting
    public static int getSize() {
        return LISTENER_MAP.size();
    }

    @VisibleForTesting
    public static void clear() {
        LISTENER_MAP.clear();
    }

    public static synchronized void update(RssConf conf, Set<String> changedProperties) {
        for (Map.Entry<Set<String>, List<ReconfigureListener>> entry : LISTENER_MAP.entrySet()) {
            Sets.SetView intersection = entry.getKey().isEmpty() ? changedProperties : Sets.intersection(entry.getKey(), changedProperties);
            if (intersection.isEmpty()) continue;
            Set filteredSet = Sets.filter((Set)changedProperties, ((Set)intersection)::contains);
            for (ReconfigureListener listener : entry.getValue()) {
                try {
                    listener.update(conf, filteredSet);
                }
                catch (Throwable e) {
                    LOG.warn("Exception while updating config for {}", (Object)changedProperties, (Object)e);
                }
            }
        }
    }

    public static interface ReconfigureListener {
        public void update(RssConf var1, Set<String> var2);
    }
}

