/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.DefaultFileRegion;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.netty.buffer.ManagedBuffer;
import org.apache.uniffle.common.util.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSegmentManagedBuffer
extends ManagedBuffer {
    private static final Logger LOG = LoggerFactory.getLogger(FileSegmentManagedBuffer.class);
    private final File file;
    private final long offset;
    private final int length;
    private volatile boolean isFilled;
    private ByteBuffer cachedBuffer;

    public FileSegmentManagedBuffer(File file, long offset, int length) {
        this.file = file;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public ByteBuf byteBuf() {
        return Unpooled.wrappedBuffer((ByteBuffer)this.nioByteBuffer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer nioByteBuffer() {
        ByteBuffer byteBuffer;
        if (this.isFilled) {
            return this.cachedBuffer;
        }
        FileChannel channel = null;
        try {
            channel = new RandomAccessFile(this.file, "r").getChannel();
            this.cachedBuffer = ByteBuffer.allocate(this.length);
            channel.position(this.offset);
            while (this.cachedBuffer.remaining() != 0) {
                if (channel.read(this.cachedBuffer) != -1) continue;
                throw new IOException(String.format("Reached EOF before filling buffer.offset=%s,file=%s,buf.remaining=%s", this.offset, this.file.getAbsoluteFile(), this.cachedBuffer.remaining()));
            }
            this.cachedBuffer.flip();
            this.isFilled = true;
            byteBuffer = this.cachedBuffer;
        }
        catch (IOException e) {
            ByteBuffer byteBuffer2;
            try {
                String fileName = this.file.getAbsolutePath();
                String errorMessage = String.format("Errors on reading localfile data with offset[%s] length[%s] from [%s]. ", this.offset, this.length, fileName);
                try {
                    if (channel != null) {
                        long size = channel.size();
                        errorMessage = errorMessage + String.format("The actual file length: %s", size);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                LOG.error(errorMessage, (Throwable)e);
                byteBuffer2 = ByteBuffer.allocate(0);
            }
            catch (Throwable throwable) {
                JavaUtils.closeQuietly(channel);
                throw throwable;
            }
            JavaUtils.closeQuietly(channel);
            return byteBuffer2;
        }
        JavaUtils.closeQuietly(channel);
        return byteBuffer;
    }

    @Override
    public ManagedBuffer retain() {
        return this;
    }

    @Override
    public ManagedBuffer release() {
        this.cachedBuffer = null;
        this.isFilled = false;
        return this;
    }

    @Override
    public Object convertToNetty() {
        FileChannel fileChannel;
        try {
            fileChannel = FileChannel.open(this.file.toPath(), StandardOpenOption.READ);
        }
        catch (IOException e) {
            throw new RssException("Errors on reading " + this.file.getAbsolutePath(), e);
        }
        return new DefaultFileRegion(fileChannel, this.offset, (long)this.length);
    }
}

