/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.channel.FileRegion;
import io.netty.util.AbstractReferenceCounted;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import org.apache.uniffle.common.netty.protocol.AbstractFileRegion;

public class CompositeFileRegion
extends AbstractFileRegion {
    private final FileRegion[] regions;
    private long totalSize = 0L;
    private long bytesTransferred = 0L;

    public CompositeFileRegion(FileRegion ... regions) {
        this.regions = regions;
        for (FileRegion region : regions) {
            this.totalSize += region.count();
        }
    }

    public long position() {
        return this.bytesTransferred;
    }

    public long count() {
        return this.totalSize;
    }

    public long transferTo(WritableByteChannel target, long position) throws IOException {
        long totalBytesTransferred = 0L;
        for (FileRegion region : this.regions) {
            if (position >= region.count()) {
                position -= region.count();
                continue;
            }
            long currentBytesTransferred = region.transferTo(target, position);
            totalBytesTransferred += currentBytesTransferred;
            this.bytesTransferred += currentBytesTransferred;
            if (currentBytesTransferred < region.count() - position) break;
            position = 0L;
        }
        return totalBytesTransferred;
    }

    public long transferred() {
        return this.bytesTransferred;
    }

    @Override
    public AbstractFileRegion retain() {
        super.retain();
        for (FileRegion region : this.regions) {
            region.retain();
        }
        return this;
    }

    @Override
    public AbstractFileRegion retain(int increment) {
        super.retain(increment);
        for (FileRegion region : this.regions) {
            region.retain(increment);
        }
        return this;
    }

    public boolean release() {
        boolean released = super.release();
        for (FileRegion region : this.regions) {
            if (region.release()) continue;
            released = false;
        }
        return released;
    }

    public boolean release(int decrement) {
        boolean released = super.release(decrement);
        for (FileRegion region : this.regions) {
            if (region.release(decrement)) continue;
            released = false;
        }
        return released;
    }

    protected void deallocate() {
        for (FileRegion region : this.regions) {
            if (!(region instanceof AbstractReferenceCounted)) continue;
            ((AbstractReferenceCounted)region).deallocate();
        }
    }

    @Override
    public AbstractFileRegion touch() {
        super.touch();
        for (FileRegion region : this.regions) {
            region.touch();
        }
        return this;
    }

    @Override
    public AbstractFileRegion touch(Object hint) {
        super.touch(hint);
        for (FileRegion region : this.regions) {
            region.touch(hint);
        }
        return this;
    }
}

