/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.rpc;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.uniffle.proto.RssProtos;

public enum StatusCode {
    SUCCESS(0),
    DOUBLE_REGISTER(1),
    NO_BUFFER(2),
    INVALID_STORAGE(3),
    NO_REGISTER(4),
    NO_PARTITION(5),
    INTERNAL_ERROR(6),
    TIMEOUT(7),
    ACCESS_DENIED(8),
    INVALID_REQUEST(9),
    NO_BUFFER_FOR_HUGE_PARTITION(10),
    STAGE_RETRY_IGNORE(11),
    EXCEED_HUGE_PARTITION_HARD_LIMIT(12),
    APP_NOT_FOUND(13),
    INTERNAL_NOT_RETRY_ERROR(14),
    UNKNOWN(-1);

    static final Map<Integer, StatusCode> VALUE_MAP;
    private final int statusCode;

    private StatusCode(int code) {
        this.statusCode = code;
    }

    public int statusCode() {
        return this.statusCode;
    }

    public static StatusCode fromCode(Integer code) {
        StatusCode statusCode = VALUE_MAP.get(code);
        return statusCode == null ? UNKNOWN : statusCode;
    }

    public RssProtos.StatusCode toProto() {
        RssProtos.StatusCode code = RssProtos.StatusCode.forNumber(this.statusCode());
        return code == null ? RssProtos.StatusCode.UNRECOGNIZED : code;
    }

    public static StatusCode fromProto(RssProtos.StatusCode status) {
        return StatusCode.fromCode(status.getNumber());
    }

    static {
        VALUE_MAP = Arrays.stream(StatusCode.values()).collect(Collectors.toMap(StatusCode::statusCode, s -> s));
    }
}

