/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler.impl;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.uniffle.common.StorageType;

public class ShuffleServerReadCost {
    private final String shuffleServerId;
    private final AtomicLong durationMillis;
    private final AtomicLong readBytes;
    private final AtomicLong memoryReadBytes;
    private final AtomicLong memoryReadDurationMillis;
    private final AtomicLong localfileReadBytes;
    private final AtomicLong localfileReadDurationMillis;
    private final AtomicLong hadoopReadLocalFileBytes;
    private final AtomicLong hadoopReadLocalFileDurationMillis;

    public ShuffleServerReadCost(String shuffleServerId) {
        this.shuffleServerId = shuffleServerId;
        this.durationMillis = new AtomicLong(0L);
        this.readBytes = new AtomicLong(0L);
        this.memoryReadBytes = new AtomicLong(0L);
        this.memoryReadDurationMillis = new AtomicLong(0L);
        this.localfileReadBytes = new AtomicLong(0L);
        this.localfileReadDurationMillis = new AtomicLong(0L);
        this.hadoopReadLocalFileBytes = new AtomicLong(0L);
        this.hadoopReadLocalFileDurationMillis = new AtomicLong(0L);
    }

    public void inc(StorageType storageType, long bytes, long durationMillis) {
        this.durationMillis.addAndGet(durationMillis);
        this.readBytes.addAndGet(bytes);
        switch (storageType) {
            case MEMORY: {
                this.memoryReadBytes.addAndGet(bytes);
                this.memoryReadDurationMillis.addAndGet(durationMillis);
                break;
            }
            case LOCALFILE: {
                this.localfileReadBytes.addAndGet(bytes);
                this.localfileReadDurationMillis.addAndGet(durationMillis);
                break;
            }
            case HDFS: {
                this.hadoopReadLocalFileBytes.addAndGet(bytes);
                this.hadoopReadLocalFileDurationMillis.addAndGet(durationMillis);
                break;
            }
        }
    }

    public long getDurationMillis() {
        return this.durationMillis.get();
    }

    public long getReadBytes() {
        return this.readBytes.get();
    }

    public long getMemoryReadBytes() {
        return this.memoryReadBytes.get();
    }

    public long getMemoryReadDurationMillis() {
        return this.memoryReadDurationMillis.get();
    }

    public long getLocalfileReadBytes() {
        return this.localfileReadBytes.get();
    }

    public long getHadoopReadLocalFileBytes() {
        return this.hadoopReadLocalFileBytes.get();
    }

    public long getLocalfileReadDurationMillis() {
        return this.localfileReadDurationMillis.get();
    }

    public long getHadoopReadLocalFileDurationMillis() {
        return this.hadoopReadLocalFileDurationMillis.get();
    }
}

