/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common;

import org.apache.uniffle.proto.RssProtos;

public class ShuffleReadTimes {
    private long fetch;
    private long crc;
    private long copy;
    private long deserialize;
    private long decompress;

    public ShuffleReadTimes() {
    }

    public ShuffleReadTimes(long fetch, long crc, long copy) {
        this.fetch = fetch;
        this.crc = crc;
        this.copy = copy;
    }

    public long getFetch() {
        return this.fetch;
    }

    public long getCrc() {
        return this.crc;
    }

    public long getCopy() {
        return this.copy;
    }

    public void withDeserialized(long deserialized) {
        this.deserialize = deserialized;
    }

    public void withDecompressed(long decompressed) {
        this.decompress = decompressed;
    }

    public long getDeserialize() {
        return this.deserialize;
    }

    public long getDecompress() {
        return this.decompress;
    }

    public void merge(ShuffleReadTimes other) {
        this.fetch += other.fetch;
        this.crc += other.crc;
        this.copy += other.copy;
        this.deserialize += other.deserialize;
        this.decompress += other.decompress;
    }

    public long getTotal() {
        return this.fetch + this.crc + this.copy + this.deserialize + this.decompress;
    }

    public RssProtos.ShuffleReadTimes toProto() {
        return RssProtos.ShuffleReadTimes.newBuilder().setFetch(this.fetch).setCrc(this.crc).setCopy(this.copy).setDecompress(this.decompress).setDeserialize(this.deserialize).build();
    }

    public static ShuffleReadTimes fromProto(RssProtos.ShuffleReadTimes proto) {
        ShuffleReadTimes time = new ShuffleReadTimes();
        time.fetch = proto.getFetch();
        time.crc = proto.getCrc();
        time.copy = proto.getCopy();
        time.decompress = proto.getDecompress();
        time.deserialize = proto.getDeserialize();
        return time;
    }
}

