/*
 * Decompiled with CFR 0.152.
 */
package org.metatype.sxc.jaxb;

import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.UnmarshalException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEvent;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.ValidationEventLocator;
import jakarta.xml.bind.helpers.ValidationEventImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.metatype.sxc.jaxb.ExtendedMarshaller;
import org.metatype.sxc.jaxb.ExtendedUnmarshaller;
import org.metatype.sxc.jaxb.IdRefTarget;
import org.metatype.sxc.jaxb.LifecycleCallback;
import org.metatype.sxc.jaxb.ValidationEventLocatorImpl;
import org.metatype.sxc.util.Attribute;
import org.metatype.sxc.util.XoXMLStreamReader;
import org.metatype.sxc.util.XoXMLStreamWriter;
import org.w3c.dom.Element;

public class RuntimeContext {
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Map<String, Object> idRegistry = new HashMap<String, Object>();
    private final Map<String, Collection<IdRefTarget>> unresolvedRefs = new HashMap<String, Collection<IdRefTarget>>();
    private final ExtendedMarshaller marshaller;
    private final ExtendedUnmarshaller unmarshaller;
    private final LinkedList<Object> stack = new LinkedList();

    public RuntimeContext() {
        this.marshaller = null;
        this.unmarshaller = null;
    }

    public RuntimeContext(ExtendedUnmarshaller unmarshaller) {
        this.marshaller = null;
        this.unmarshaller = unmarshaller;
    }

    public RuntimeContext(ExtendedMarshaller marshaller) {
        this.marshaller = marshaller;
        this.unmarshaller = null;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Object setProperty(String name, Object value) {
        return this.properties.put(name, value);
    }

    public void addXmlId(XoXMLStreamReader reader, String id, Object value) throws JAXBException {
        if (reader == null) {
            throw new NullPointerException("reader is null");
        }
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        if (value == null) {
            throw new NullPointerException("object is null");
        }
        if (this.idRegistry.containsKey(id)) {
            String message = "Duplicate xml id " + id;
            this.validationError(message, reader.getLocation(), null);
        } else {
            this.idRegistry.put(id, value);
        }
    }

    public void resolveXmlIdRef(XoXMLStreamReader reader, String id, IdRefTarget target) throws JAXBException {
        if (reader == null) {
            throw new NullPointerException("reader is null");
        }
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        if (target == null) {
            throw new NullPointerException("object is null");
        }
        if (this.idRegistry.containsKey(id)) {
            Object value = this.idRegistry.get(id);
            target.resolved(value);
        } else {
            Collection<IdRefTarget> targets = this.unresolvedRefs.get(id);
            if (targets == null) {
                targets = new ArrayList<IdRefTarget>();
                this.unresolvedRefs.put(id, targets);
            }
            targets.add(target);
        }
    }

    public void resolveXmlIdRefs() throws JAXBException {
        ArrayList<String> unresolvedIds = new ArrayList<String>();
        for (Map.Entry<String, Collection<IdRefTarget>> entry : this.unresolvedRefs.entrySet()) {
            String id = entry.getKey();
            if (this.idRegistry.containsKey(id)) {
                Object value = this.idRegistry.get(id);
                for (IdRefTarget target : entry.getValue()) {
                    target.resolved(value);
                }
                continue;
            }
            unresolvedIds.add(id);
        }
        if (!unresolvedIds.isEmpty()) {
            // empty if block
        }
    }

    public void beforeUnmarshal(Object bean, LifecycleCallback lifecycleCallback) throws Exception {
        Object parent = null;
        if (!this.stack.isEmpty()) {
            parent = this.stack.getFirst();
        }
        this.stack.addFirst(bean);
        if (this.unmarshaller != null) {
            Unmarshaller.Listener listener;
            if (lifecycleCallback != null) {
                lifecycleCallback.beforeUnmarshal(bean, this.unmarshaller, parent);
            }
            if ((listener = this.unmarshaller.getListener()) != null) {
                listener.beforeUnmarshal(bean, parent);
            }
        }
    }

    public void afterUnmarshal(Object bean, LifecycleCallback lifecycleCallback) throws Exception {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("afterUnmarshal called without beforeUnmarshal being called first");
        }
        this.stack.removeFirst();
        Object parent = null;
        if (!this.stack.isEmpty()) {
            parent = this.stack.getFirst();
        }
        if (this.unmarshaller != null) {
            Unmarshaller.Listener listener;
            if (lifecycleCallback != null) {
                lifecycleCallback.afterUnmarshal(bean, this.unmarshaller, parent);
            }
            if ((listener = this.unmarshaller.getListener()) != null) {
                listener.afterUnmarshal(bean, parent);
            }
        }
    }

    public void beforeMarshal(Object bean, LifecycleCallback lifecycleCallback) throws Exception {
        if (this.stack.contains(bean)) {
            ValidationEventHandler validationEventHandler;
            ArrayList<Object> cycle = new ArrayList<Object>(this.stack);
            Collections.reverse(cycle);
            cycle.add(bean);
            String message = "Marshal cycle detected " + cycle;
            if (this.marshaller != null && (validationEventHandler = this.marshaller.getEventHandler()) != null) {
                validationEventHandler.handleEvent((ValidationEvent)new ValidationEventImpl(2, message, (ValidationEventLocator)new ValidationEventLocatorImpl(bean, null)));
            }
            throw new UnmarshalException(message);
        }
        this.stack.addFirst(bean);
        if (this.marshaller != null) {
            Marshaller.Listener listener;
            if (lifecycleCallback != null) {
                lifecycleCallback.beforeMarshal(bean, this.marshaller);
            }
            if ((listener = this.marshaller.getListener()) != null) {
                listener.beforeMarshal(bean);
            }
        }
    }

    public void afterMarshal(Object bean, LifecycleCallback lifecycleCallback) throws Exception {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("afterMarshal called without beforeMarshal being called first");
        }
        this.stack.removeFirst();
        if (this.marshaller != null) {
            Marshaller.Listener listener;
            if (lifecycleCallback != null) {
                lifecycleCallback.afterMarshal(bean, this.marshaller);
            }
            if ((listener = this.marshaller.getListener()) != null) {
                listener.afterMarshal(bean);
            }
        }
    }

    public void unexpectedAttribute(Attribute attribute, QName ... expectedAttributes) throws JAXBException {
        String message = "Unexpected attribute " + attribute.getName() + ", expected " + Arrays.toString(expectedAttributes);
        this.validationError(message, attribute.getReader().getLocation(), null);
    }

    public void unexpectedElement(XoXMLStreamReader reader, QName ... expectedElements) throws JAXBException {
        String message = "Unexpected element " + reader.getName() + ", expected " + Arrays.toString(expectedElements);
        this.validationError(message, reader.getLocation(), null);
    }

    public <T> T unexpectedXsiType(XoXMLStreamReader reader, Class<T> expectedJavaType) throws JAXBException {
        if (this.unmarshaller != null) {
            Object value = this.unmarshaller.read((XMLStreamReader)reader, expectedJavaType, false, this);
            return (T)value;
        }
        String message = "Unexpected xsi:type " + reader.getXsiType() + ", expected " + expectedJavaType;
        this.validationError(message, reader.getLocation(), null);
        return null;
    }

    public void unexpectedSubclass(XoXMLStreamWriter writer, Object bean, Class baseClass, Class ... expectedSubclasses) throws JAXBException {
        if (this.marshaller != null) {
            this.marshaller.write(bean, writer, this, false, true);
            return;
        }
        String message = "Unknown subclass " + bean.getClass().getName() + " of base class " + baseClass.getName() + ", expected [";
        for (int i = 0; i < expectedSubclasses.length; ++i) {
            if (i != 0) {
                message = message + ", ";
            }
            Class expectedSubclass = expectedSubclasses[i];
            message = message + expectedSubclass.getName();
        }
        message = message + "]";
        this.validationError(message, new ValidationEventLocatorImpl(bean, null), null);
    }

    public <T> T readXmlAny(XoXMLStreamReader reader, Class<T> expectedJavaType, boolean lax) throws JAXBException, XMLStreamException {
        if (this.unmarshaller != null && lax) {
            Object value = this.unmarshaller.read((XMLStreamReader)reader, Object.class, null, this);
            return (T)value;
        }
        return (T)reader.getElementAsDomElement();
    }

    public void unexpectedNullValue(Object bean, String propertyName) throws JAXBException {
    }

    public void unexpectedElementType(XoXMLStreamWriter writer, Object bean, String propertyName, Object propertyValue, Class ... expectedTypes) throws JAXBException {
        String message = "Property " + bean.getClass().getName() + "." + propertyName + " value is the unexpected type " + propertyName.getClass().getName() + ", expected [";
        for (int i = 0; i < expectedTypes.length; ++i) {
            if (i != 0) {
                message = message + ", ";
            }
            Class expectedType = expectedTypes[i];
            message = message + expectedType.getName();
        }
        message = message + "]";
        this.validationError(message, new ValidationEventLocatorImpl(bean, propertyName), null);
    }

    public void unexpectedElementRef(XoXMLStreamWriter writer, Object bean, String propertyName, Object propertyValue, Class ... expectedTypes) throws JAXBException {
        if (propertyValue == null) {
            return;
        }
        if (this.marshaller != null) {
            this.marshaller.write(propertyValue, writer, this, true, false);
            return;
        }
        String message = "Property " + bean.getClass().getName() + "." + propertyName + " value is the unexpected type " + propertyName.getClass().getName() + ", expected [";
        for (int i = 0; i < expectedTypes.length; ++i) {
            if (i != 0) {
                message = message + ", ";
            }
            Class expectedType = expectedTypes[i];
            message = message + expectedType.getName();
        }
        message = message + "]";
        this.validationError(message, new ValidationEventLocatorImpl(bean, propertyName), null);
    }

    public void writeXmlAny(XoXMLStreamWriter writer, Object bean, String propertyName, Object propertyValue) throws JAXBException, XMLStreamException {
        if (propertyValue == null) {
            return;
        }
        if (propertyValue instanceof Element) {
            Element element = (Element)propertyValue;
            writer.writeDomElement(element, true);
            return;
        }
        if (this.marshaller != null) {
            this.marshaller.write(propertyValue, writer, this, true, false);
            return;
        }
        String message = "A marshaler ie required to write value of type " + propertyValue.getClass().getName() + " for property " + bean.getClass().getName() + "." + propertyName;
        this.validationError(message, new ValidationEventLocatorImpl(bean, propertyName), null);
    }

    public void unexpectedEnumValue(XoXMLStreamReader reader, Class enumType, String value, String ... expectedValues) throws JAXBException {
        String message = "Unexpected XML value \"" + value + "\" for enum " + enumType.getName() + ", expected " + Arrays.toString(expectedValues);
        this.validationError(message, reader.getLocation(), null);
    }

    public <T> void unexpectedEnumConst(Object bean, String propertyName, T value, T ... expectedValues) throws JAXBException {
        String message = "Unexpected constant \"" + value + "\" for enum " + value.getClass().getName() + ", expected " + Arrays.toString(expectedValues);
        this.validationError(message, new ValidationEventLocatorImpl(bean, propertyName), null);
    }

    public void xmlAdapterError(XoXMLStreamReader reader, Class adapterClass, Class sourceType, Class destinationType, Exception e) throws JAXBException {
        String message = "An error occured while converting an instance of " + sourceType.getName() + " to an instance of " + destinationType.getName() + " using XmlAdapter " + adapterClass.getName();
        this.validationError(message, reader.getLocation(), (Throwable)e);
    }

    public void xmlAdapterError(Object bean, String propertyName, Class adapterClass, Class sourceType, Class destinationType, Exception e) throws JAXBException {
        String message = "An error occured while converting an instance of " + sourceType.getName() + " to an instance of " + destinationType.getName() + " using XmlAdapter " + adapterClass.getName();
        this.validationError(message, new ValidationEventLocatorImpl(bean, propertyName), (Throwable)e);
    }

    public void uncreatableCollection(XoXMLStreamReader reader, Class beanType, String propertyName, Class collectionType) throws JAXBException {
        String message = "Collection property " + propertyName + " in class " + beanType.getName() + " is null and a new instance of " + collectionType.getName() + " can not be created";
        this.validationError(message, reader.getLocation(), null);
    }

    public void fieldGetError(XoXMLStreamReader reader, Class beanType, String fieldName, Exception e) throws JAXBException {
        String message = "An error occured while getting field value " + beanType.getName() + "." + fieldName;
        this.validationError(message, reader.getLocation(), (Throwable)e);
    }

    public void fieldGetError(Object bean, String propertyName, Class beanType, String fieldName, Exception e) throws JAXBException {
        String message = "An error occured while getting field value " + beanType.getName() + "." + fieldName;
        this.validationError(message, new ValidationEventLocatorImpl(bean, propertyName), (Throwable)e);
    }

    public void fieldSetError(XoXMLStreamReader reader, Class beanType, String fieldName, Exception e) throws JAXBException {
        String message = "An error occured while setting field value " + beanType.getName() + "." + fieldName;
        this.validationError(message, reader.getLocation(), (Throwable)e);
    }

    public void getterError(XoXMLStreamReader reader, Class beanType, String getterName, Exception e) throws JAXBException {
        String message = "An error occured while calling getter method " + beanType.getName() + "." + getterName + "()";
        this.validationError(message, reader.getLocation(), (Throwable)e);
    }

    public void getterError(Object bean, String propertyName, Class beanType, String getterName, Exception e) throws JAXBException {
        String message = "An error occured while calling getter method " + beanType.getName() + "." + getterName + "()";
        this.validationError(message, new ValidationEventLocatorImpl(bean, propertyName), (Throwable)e);
    }

    public void setterError(XoXMLStreamReader reader, Class beanType, String setterName, Class propertyType, Exception e) throws JAXBException {
        String message = "An error occured while calling setter method " + beanType.getName() + "." + setterName + "(" + propertyType.getName() + ")";
        this.validationError(message, reader.getLocation(), (Throwable)e);
    }

    private void validationError(String message, Location location, Throwable cause) throws JAXBException {
        this.validationError(message, new ValidationEventLocatorImpl(location), cause);
    }

    private void validationError(String message, ValidationEventLocatorImpl locator, Throwable cause) throws JAXBException {
        ValidationEventHandler validationEventHandler = null;
        if (this.marshaller != null) {
            validationEventHandler = this.marshaller.getEventHandler();
        } else if (this.unmarshaller != null) {
            validationEventHandler = this.unmarshaller.getEventHandler();
        }
        if (validationEventHandler == null || !validationEventHandler.handleEvent((ValidationEvent)new ValidationEventImpl(1, message, (ValidationEventLocator)locator, cause))) {
            throw new UnmarshalException(message, cause);
        }
    }
}

