/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.log;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class FileHandler
extends Handler {
    private volatile String date = "";
    private String directory;
    private String prefix;
    private String suffix;
    private boolean rotatable = true;
    private volatile PrintWriter writer;
    protected ReadWriteLock writerLock = new ReentrantReadWriteLock();
    private int bufferSize = -1;

    public FileHandler() {
        this(null, null, null);
    }

    public FileHandler(String directory, String prefix, String suffix) {
        this.directory = directory;
        this.prefix = prefix;
        this.suffix = suffix;
        this.configure();
        this.openWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        String tsString = ts.toString().substring(0, 19);
        String tsDate = tsString.substring(0, 10);
        try {
            this.writerLock.readLock().lock();
            if (this.rotatable && !this.date.equals(tsDate)) {
                try {
                    this.writerLock.readLock().unlock();
                    this.writerLock.writeLock().lock();
                    if (!this.date.equals(tsDate)) {
                        this.closeWriter();
                        this.date = tsDate;
                        this.openWriter();
                    }
                }
                finally {
                    this.writerLock.writeLock().unlock();
                    this.writerLock.readLock().lock();
                }
            }
            String result = null;
            try {
                result = this.getFormatter().format(record);
            }
            catch (Exception e) {
                this.reportError(null, e, 5);
                this.writerLock.readLock().unlock();
                return;
            }
            try {
                if (this.writer != null) {
                    this.writer.write(result);
                    if (this.bufferSize < 0) {
                        this.writer.flush();
                    }
                } else {
                    this.reportError("FileHandler is closed or not yet initialized, unable to log [" + result + "]", null, 1);
                }
            }
            catch (Exception e) {
                this.reportError(null, e, 1);
                this.writerLock.readLock().unlock();
                return;
            }
        }
        finally {
            this.writerLock.readLock().unlock();
        }
    }

    @Override
    public void close() {
        this.closeWriter();
    }

    protected void closeWriter() {
        this.writerLock.writeLock().lock();
        try {
            if (this.writer == null) {
                return;
            }
            this.writer.write(this.getFormatter().getTail(this));
            this.writer.flush();
            this.writer.close();
            this.writer = null;
            this.date = "";
        }
        catch (Exception e) {
            this.reportError(null, e, 3);
        }
        finally {
            this.writerLock.writeLock().unlock();
        }
    }

    @Override
    public void flush() {
        this.writerLock.readLock().lock();
        try {
            if (this.writer == null) {
                return;
            }
            this.writer.flush();
        }
        catch (Exception e) {
            this.reportError(null, e, 2);
        }
        finally {
            this.writerLock.readLock().unlock();
        }
    }

    private void configure() {
        String formatterName;
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        String tsString = ts.toString().substring(0, 19);
        this.date = tsString.substring(0, 10);
        String className = this.getClass().getName();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        this.rotatable = Boolean.parseBoolean(this.getProperty(className + ".rotatable", "true"));
        if (this.directory == null) {
            this.directory = this.getProperty(className + ".directory", "logs");
        }
        if (this.prefix == null) {
            this.prefix = this.getProperty(className + ".prefix", "juli.");
        }
        if (this.suffix == null) {
            this.suffix = this.getProperty(className + ".suffix", ".log");
        }
        String sBufferSize = this.getProperty(className + ".bufferSize", String.valueOf(this.bufferSize));
        try {
            this.bufferSize = Integer.parseInt(sBufferSize);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String encoding = this.getProperty(className + ".encoding", null);
        if (encoding != null && encoding.length() > 0) {
            try {
                this.setEncoding(encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.setLevel(Level.parse(this.getProperty(className + ".level", String.valueOf(Level.ALL))));
        String filterName = this.getProperty(className + ".filter", null);
        if (filterName != null) {
            try {
                this.setFilter((Filter)cl.loadClass(filterName).newInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((formatterName = this.getProperty(className + ".formatter", null)) != null) {
            try {
                this.setFormatter((Formatter)cl.loadClass(formatterName).newInstance());
            }
            catch (Exception e) {
                this.setFormatter(new SimpleFormatter());
            }
        } else {
            this.setFormatter(new SimpleFormatter());
        }
        this.setErrorManager(new ErrorManager());
    }

    private String getProperty(String name, String defaultValue) {
        String value = LogManager.getLogManager().getProperty(name);
        value = value == null ? defaultValue : value.trim();
        return value;
    }

    protected void open() {
        this.openWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openWriter() {
        File dir = new File(this.directory);
        if (!dir.mkdirs() && !dir.isDirectory()) {
            this.reportError("Unable to create [" + String.valueOf(dir) + "]", null, 4);
            this.writer = null;
            return;
        }
        this.writerLock.writeLock().lock();
        try {
            File pathname = new File(dir.getAbsoluteFile(), this.prefix + (this.rotatable ? this.date : "") + this.suffix);
            File parent = pathname.getParentFile();
            if (!parent.mkdirs() && !parent.isDirectory()) {
                this.reportError("Unable to create [" + String.valueOf(parent) + "]", null, 4);
                this.writer = null;
                return;
            }
            String encoding = this.getEncoding();
            FileOutputStream fos = new FileOutputStream(pathname, true);
            OutputStream os = this.bufferSize > 0 ? new BufferedOutputStream(fos, this.bufferSize) : fos;
            this.writer = new PrintWriter((Writer)(encoding != null ? new OutputStreamWriter(os, encoding) : new OutputStreamWriter(os)), false);
            this.writer.write(this.getFormatter().getHead(this));
        }
        catch (Exception e) {
            this.reportError(null, e, 4);
            this.writer = null;
        }
        finally {
            this.writerLock.writeLock().unlock();
        }
    }
}

