/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.versionmigrator;

public final class ClassRefactor {
    private final String newClassName;
    private final String oldClassName;
    private final String sourceArtifact;
    private final String destinationArtifact;

    public ClassRefactor(String newClassName, String oldClassName, String sourceArtifact, String destinationArtifact) {
        ClassRefactor.verifyNotBlank("newClassName", newClassName);
        ClassRefactor.verifyNotBlank("oldClassName", oldClassName);
        ClassRefactor.verifyNotBlank("sourceArtifact", sourceArtifact);
        ClassRefactor.verifyNotBlank("destinationArtifact", destinationArtifact);
        this.newClassName = newClassName;
        this.oldClassName = oldClassName;
        this.sourceArtifact = sourceArtifact;
        this.destinationArtifact = destinationArtifact;
    }

    public String getNewClassName() {
        return this.newClassName;
    }

    public String getOldClassName() {
        return this.oldClassName;
    }

    public String getSourceArtifact() {
        return this.sourceArtifact;
    }

    public String getDestinationArtifact() {
        return this.destinationArtifact;
    }

    public boolean isMovedBetweenArtifacts() {
        return !this.sourceArtifact.equals(this.destinationArtifact);
    }

    public boolean isRenamed() {
        return !this.oldClassName.equals(this.newClassName);
    }

    public String toString() {
        return "ClassMoveInformation [newClassName=" + this.newClassName + ", oldClassName=" + this.oldClassName + ", sourceArtifact=" + this.sourceArtifact + ", destinationArtifact=" + this.destinationArtifact + "]";
    }

    static final boolean isNotBlank(String string) {
        return string != null && string.trim().length() > 0;
    }

    static final void verifyNotBlank(String parameterName, String parameterValue) {
        if (!ClassRefactor.isNotBlank(parameterValue)) {
            throw new IllegalArgumentException(String.format("Parameter %s cannot be null nor blank", parameterName));
        }
    }

    public String getSimpleOldClassName() {
        return this.oldClassName.substring(this.oldClassName.lastIndexOf(".") + 1);
    }

    public boolean isInternal() {
        return this.oldClassName.contains(".internal.");
    }

    public String getNewPackageName() {
        return this.newClassName.substring(0, this.newClassName.lastIndexOf("."));
    }
}

