/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.iogen;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.util.UtilFunctions;

public class RawIndex {
    private String raw;
    private int rawLength;
    private BitSet numberBitSet;
    private BitSet dotBitSet;
    private BitSet eBitSet;
    private BitSet plusMinusBitSet;
    private BitSet reservedPositions;
    private BitSet backupReservedPositions;
    private HashMap<Double, ArrayList<Pair<Integer, Integer>>> actualNumericValues;
    private HashMap<Double, ArrayList<Pair<Integer, Integer>>> dotActualNumericValues;
    private HashMap<Double, ArrayList<Pair<Integer, Integer>>> dotEActualNumericValues;

    public RawIndex(String raw) {
        boolean flag;
        int i;
        this.raw = raw;
        this.rawLength = raw.length();
        this.numberBitSet = new BitSet(this.rawLength);
        this.dotBitSet = new BitSet(this.rawLength);
        this.eBitSet = new BitSet(this.rawLength);
        this.plusMinusBitSet = new BitSet(this.rawLength);
        this.reservedPositions = new BitSet(this.rawLength);
        this.backupReservedPositions = new BitSet(this.rawLength);
        this.actualNumericValues = null;
        this.dotActualNumericValues = null;
        this.dotEActualNumericValues = new HashMap();
        block6: for (i = 0; i < this.rawLength; ++i) {
            switch (raw.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.numberBitSet.set(i);
                    continue block6;
                }
                case '+': 
                case '-': {
                    this.plusMinusBitSet.set(i);
                    continue block6;
                }
                case '.': {
                    this.dotBitSet.set(i);
                    continue block6;
                }
                case 'E': 
                case 'e': {
                    this.eBitSet.set(i);
                }
            }
        }
        i = this.dotBitSet.nextSetBit(0);
        while (i != -1) {
            flag = false;
            if (i > 0) {
                if (i < this.rawLength - 2) {
                    flag = !this.numberBitSet.get(i - 1) && !this.numberBitSet.get(i + 1) && !this.plusMinusBitSet.get(i + 1) && !this.eBitSet.get(i + 1);
                }
            } else if (i == this.rawLength - 1) {
                flag = !this.numberBitSet.get(i - 1);
            } else if (i == 0) {
                if (i < this.rawLength - 2) {
                    flag = !this.numberBitSet.get(i + 1) && !this.plusMinusBitSet.get(i + 1) && !this.eBitSet.get(i + 1);
                } else if (i == this.rawLength - 1) {
                    flag = true;
                }
            }
            if (flag) {
                this.dotBitSet.set(i, false);
            }
            i = this.dotBitSet.nextSetBit(i + 1);
        }
        i = this.plusMinusBitSet.nextSetBit(0);
        while (i != -1) {
            if (i < this.rawLength - 1) {
                flag = this.numberBitSet.get(i + 1);
                if (!flag && i < this.rawLength - 2) {
                    flag = this.dotBitSet.get(i + 1) && this.numberBitSet.get(i + 2);
                }
            } else {
                flag = false;
            }
            if (!flag) {
                this.plusMinusBitSet.set(i, false);
            }
            i = this.plusMinusBitSet.nextSetBit(i + 1);
        }
        i = this.eBitSet.nextSetBit(0);
        while (i != -1) {
            flag = false;
            if (i == 1 && !this.numberBitSet.get(0) || i == 0 || i == this.rawLength - 1) {
                flag = false;
            } else if (i > 1 && i < this.rawLength - 2) {
                boolean bl = flag = this.numberBitSet.get(i - 1) || this.numberBitSet.get(i - 2) && this.dotBitSet.get(i - 1);
                if (flag) {
                    flag = this.numberBitSet.get(i + 1) || this.numberBitSet.get(i + 2) && this.plusMinusBitSet.get(i + 1);
                }
            } else if (i == this.rawLength - 2) {
                flag = this.numberBitSet.get(this.rawLength - 1);
            }
            if (!flag) {
                this.eBitSet.set(i, false);
            }
            i = this.eBitSet.nextSetBit(i + 1);
        }
        if (this.numberBitSet.cardinality() > 0) {
            this.extractNumericDotEActualValues();
        }
    }

    public RawIndex() {
    }

    public Pair<Integer, Integer> findValue(Object value, Types.ValueType valueType) {
        if (valueType.isNumeric()) {
            return this.findValue(UtilFunctions.getDouble(value));
        }
        if (valueType == Types.ValueType.STRING) {
            String os = UtilFunctions.objectToString(value);
            if (os == null || os.length() == 0) {
                return null;
            }
            return this.findValue(os);
        }
        return null;
    }

    public Pair<Integer, Integer> findValue(double value) {
        if (this.dotEActualNumericValues.containsKey(value)) {
            return this.getValuePositionAndLength(this.dotEActualNumericValues.get(value));
        }
        return null;
    }

    private Pair<Integer, Integer> findValue(String value) {
        boolean flag;
        int index = 0;
        do {
            flag = true;
            if ((index = this.raw.indexOf(value, index)) == -1) {
                return null;
            }
            for (int i = index; i < index + value.length(); ++i) {
                if (!this.reservedPositions.get(i)) continue;
                flag = false;
                break;
            }
            if (flag) continue;
            index += value.length();
        } while (!flag);
        this.reservedPositions.set(index, index + value.length());
        return new Pair<Integer, Integer>(index, value.length());
    }

    private Pair<Integer, Integer> getValuePositionAndLength(ArrayList<Pair<Integer, Integer>> list) {
        for (Pair<Integer, Integer> p : list) {
            if (this.reservedPositions.get(p.getKey())) continue;
            this.reservedPositions.set((int)p.getKey(), p.getKey() + p.getValue());
            return p;
        }
        return null;
    }

    private void extractNumericActualValues() {
        if (this.actualNumericValues != null) {
            return;
        }
        this.actualNumericValues = new HashMap();
        StringBuilder sb = new StringBuilder();
        BitSet nBitSet = (BitSet)this.numberBitSet.clone();
        nBitSet.or(this.plusMinusBitSet);
        int pi = nBitSet.nextSetBit(0);
        sb.append(this.raw.charAt(pi));
        int i = nBitSet.nextSetBit(pi + 1);
        while (i != -1) {
            if (pi + sb.length() != i) {
                this.addActualValueToList(sb.toString(), pi, this.actualNumericValues);
                sb = new StringBuilder();
                sb.append(this.raw.charAt(i));
                pi = i;
            } else {
                sb.append(this.raw.charAt(i));
            }
            i = nBitSet.nextSetBit(i + 1);
        }
        if (sb.length() > 0) {
            this.addActualValueToList(sb.toString(), pi, this.actualNumericValues);
        }
    }

    private void extractNumericDotActualValues() {
        if (this.dotActualNumericValues != null) {
            return;
        }
        this.dotActualNumericValues = new HashMap();
        BitSet numericDotBitSet = (BitSet)this.numberBitSet.clone();
        numericDotBitSet.or(this.dotBitSet);
        numericDotBitSet.or(this.plusMinusBitSet);
        StringBuilder sb = new StringBuilder();
        int pi = numericDotBitSet.nextSetBit(0);
        sb.append(this.raw.charAt(pi));
        int i = numericDotBitSet.nextSetBit(pi + 1);
        while (i != -1) {
            if (pi + sb.length() != i) {
                this.addActualValueToList(sb.toString(), pi, this.dotActualNumericValues);
                sb = new StringBuilder();
                sb.append(this.raw.charAt(i));
                pi = i;
            } else {
                sb.append(this.raw.charAt(i));
            }
            i = numericDotBitSet.nextSetBit(i + 1);
        }
        if (sb.length() > 0) {
            this.addActualValueToList(sb.toString(), pi, this.dotActualNumericValues);
        }
    }

    private void extractNumericDotEActualValues() {
        BitSet numericDotEBitSet = (BitSet)this.numberBitSet.clone();
        numericDotEBitSet.or(this.dotBitSet);
        numericDotEBitSet.or(this.eBitSet);
        numericDotEBitSet.or(this.plusMinusBitSet);
        StringBuilder sb = new StringBuilder();
        int pi = numericDotEBitSet.nextSetBit(0);
        sb.append(this.raw.charAt(pi));
        int i = numericDotEBitSet.nextSetBit(pi + 1);
        while (i != -1) {
            if (pi + sb.length() != i) {
                this.addActualValueToList(sb.toString(), pi, this.dotEActualNumericValues);
                sb = new StringBuilder();
                sb.append(this.raw.charAt(i));
                pi = i;
            } else {
                sb.append(this.raw.charAt(i));
            }
            i = numericDotEBitSet.nextSetBit(i + 1);
        }
        if (sb.length() > 0) {
            this.addActualValueToList(sb.toString(), pi, this.dotEActualNumericValues);
        }
    }

    private void addActualValueToList(String stringValue, Integer position, HashMap<Double, ArrayList<Pair<Integer, Integer>>> list) {
        try {
            double d = UtilFunctions.getDouble(stringValue);
            Pair<Integer, Integer> pair = new Pair<Integer, Integer>(position, stringValue.length());
            if (!list.containsKey(d)) {
                ArrayList<Pair<Integer, Integer>> tmpList = new ArrayList<Pair<Integer, Integer>>();
                tmpList.add(pair);
                list.put(d, tmpList);
            } else {
                list.get(d).add(pair);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getRemainedTexts(int startPos, int endPos) {
        StringBuilder sb = new StringBuilder();
        StringBuilder result = new StringBuilder();
        if (endPos == -1) {
            endPos = this.rawLength;
        }
        for (int i = startPos; i < endPos; ++i) {
            if (!this.reservedPositions.get(i)) {
                sb.append(this.raw.charAt(i));
                continue;
            }
            if (sb.length() <= 0) continue;
            result.append("\u00b0").append((CharSequence)sb);
            sb = new StringBuilder();
        }
        if (sb.length() > 0) {
            result.append("\u00b0").append((CharSequence)sb);
        }
        return result.toString();
    }

    public void cloneReservedPositions() {
        this.backupReservedPositions = (BitSet)this.reservedPositions.clone();
    }

    public void restoreReservedPositions() {
        this.reservedPositions = this.backupReservedPositions;
    }

    public String getSubString(int start, int end) {
        return this.raw.substring(start, end);
    }

    public int getRawLength() {
        return this.rawLength;
    }

    public String getRaw() {
        return this.raw;
    }

    public int getNextNumericPosition(int curPosition) {
        int pos = this.rawLength;
        for (Double d : this.dotEActualNumericValues.keySet()) {
            for (Pair<Integer, Integer> p : this.dotEActualNumericValues.get(d)) {
                if (p.getKey() <= curPosition || p.getKey() >= pos) continue;
                pos = p.getKey();
            }
        }
        return pos;
    }

    public void setRaw(String raw) {
        this.raw = raw;
        this.rawLength = raw.length();
        this.reservedPositions = new BitSet(this.rawLength);
    }

    public void setReservedPositions(int pos, int len) {
        for (int i = pos; i < pos + len; ++i) {
            this.reservedPositions.set(i);
        }
    }
}

